/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.resiliencehub.ResiliencehubClient;
import software.amazon.awssdk.services.resiliencehub.model.ListAppVersionResourceMappingsRequest;
import software.amazon.awssdk.services.resiliencehub.model.ListAppVersionResourceMappingsResponse;

public class ListAppVersionResourceMappingsIterable
implements SdkIterable<ListAppVersionResourceMappingsResponse> {
    private final ResiliencehubClient client;
    private final ListAppVersionResourceMappingsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAppVersionResourceMappingsIterable(ResiliencehubClient client, ListAppVersionResourceMappingsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListAppVersionResourceMappingsResponseFetcher();
    }

    public Iterator<ListAppVersionResourceMappingsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListAppVersionResourceMappingsResponseFetcher
    implements SyncPageFetcher<ListAppVersionResourceMappingsResponse> {
        private ListAppVersionResourceMappingsResponseFetcher() {
        }

        public boolean hasNextPage(ListAppVersionResourceMappingsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAppVersionResourceMappingsResponse nextPage(ListAppVersionResourceMappingsResponse previousPage) {
            if (previousPage == null) {
                return ListAppVersionResourceMappingsIterable.this.client.listAppVersionResourceMappings(ListAppVersionResourceMappingsIterable.this.firstRequest);
            }
            return ListAppVersionResourceMappingsIterable.this.client.listAppVersionResourceMappings((ListAppVersionResourceMappingsRequest)((Object)ListAppVersionResourceMappingsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

