/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum TestType {
    SOFTWARE("Software"),
    HARDWARE("Hardware"),
    AZ("AZ"),
    REGION("Region"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, TestType> VALUE_MAP;
    private final String value;

    private TestType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TestType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TestType> knownValues() {
        EnumSet<TestType> knownValues = EnumSet.allOf(TestType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(TestType.class, TestType::toString);
    }
}

