/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.resiliencehub.ResiliencehubAsyncClient;
import software.amazon.awssdk.services.resiliencehub.model.ListResiliencyPoliciesRequest;
import software.amazon.awssdk.services.resiliencehub.model.ListResiliencyPoliciesResponse;

public class ListResiliencyPoliciesPublisher
implements SdkPublisher<ListResiliencyPoliciesResponse> {
    private final ResiliencehubAsyncClient client;
    private final ListResiliencyPoliciesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListResiliencyPoliciesPublisher(ResiliencehubAsyncClient client, ListResiliencyPoliciesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListResiliencyPoliciesPublisher(ResiliencehubAsyncClient client, ListResiliencyPoliciesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListResiliencyPoliciesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListResiliencyPoliciesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListResiliencyPoliciesResponseFetcher
    implements AsyncPageFetcher<ListResiliencyPoliciesResponse> {
        private ListResiliencyPoliciesResponseFetcher() {
        }

        public boolean hasNextPage(ListResiliencyPoliciesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListResiliencyPoliciesResponse> nextPage(ListResiliencyPoliciesResponse previousPage) {
            if (previousPage == null) {
                return ListResiliencyPoliciesPublisher.this.client.listResiliencyPolicies(ListResiliencyPoliciesPublisher.this.firstRequest);
            }
            return ListResiliencyPoliciesPublisher.this.client.listResiliencyPolicies((ListResiliencyPoliciesRequest)((Object)ListResiliencyPoliciesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

