/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.resiliencehub.model.AssessmentInvoker;
import software.amazon.awssdk.services.resiliencehub.model.AssessmentStatus;
import software.amazon.awssdk.services.resiliencehub.model.AssessmentStatusListCopier;
import software.amazon.awssdk.services.resiliencehub.model.ComplianceStatus;
import software.amazon.awssdk.services.resiliencehub.model.ResiliencehubRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAppAssessmentsRequest
extends ResiliencehubRequest
implements ToCopyableBuilder<Builder, ListAppAssessmentsRequest> {
    private static final SdkField<String> APP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("appArn").getter(ListAppAssessmentsRequest.getter(ListAppAssessmentsRequest::appArn)).setter(ListAppAssessmentsRequest.setter(Builder::appArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("appArn").build()}).build();
    private static final SdkField<String> ASSESSMENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assessmentName").getter(ListAppAssessmentsRequest.getter(ListAppAssessmentsRequest::assessmentName)).setter(ListAppAssessmentsRequest.setter(Builder::assessmentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("assessmentName").build()}).build();
    private static final SdkField<List<String>> ASSESSMENT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("assessmentStatus").getter(ListAppAssessmentsRequest.getter(ListAppAssessmentsRequest::assessmentStatusAsStrings)).setter(ListAppAssessmentsRequest.setter(Builder::assessmentStatusWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("assessmentStatus").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> COMPLIANCE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("complianceStatus").getter(ListAppAssessmentsRequest.getter(ListAppAssessmentsRequest::complianceStatusAsString)).setter(ListAppAssessmentsRequest.setter(Builder::complianceStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("complianceStatus").build()}).build();
    private static final SdkField<String> INVOKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("invoker").getter(ListAppAssessmentsRequest.getter(ListAppAssessmentsRequest::invokerAsString)).setter(ListAppAssessmentsRequest.setter(Builder::invoker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("invoker").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListAppAssessmentsRequest.getter(ListAppAssessmentsRequest::maxResults)).setter(ListAppAssessmentsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListAppAssessmentsRequest.getter(ListAppAssessmentsRequest::nextToken)).setter(ListAppAssessmentsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()}).build();
    private static final SdkField<Boolean> REVERSE_ORDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("reverseOrder").getter(ListAppAssessmentsRequest.getter(ListAppAssessmentsRequest::reverseOrder)).setter(ListAppAssessmentsRequest.setter(Builder::reverseOrder)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("reverseOrder").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_ARN_FIELD, ASSESSMENT_NAME_FIELD, ASSESSMENT_STATUS_FIELD, COMPLIANCE_STATUS_FIELD, INVOKER_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, REVERSE_ORDER_FIELD));
    private final String appArn;
    private final String assessmentName;
    private final List<String> assessmentStatus;
    private final String complianceStatus;
    private final String invoker;
    private final Integer maxResults;
    private final String nextToken;
    private final Boolean reverseOrder;

    private ListAppAssessmentsRequest(BuilderImpl builder) {
        super(builder);
        this.appArn = builder.appArn;
        this.assessmentName = builder.assessmentName;
        this.assessmentStatus = builder.assessmentStatus;
        this.complianceStatus = builder.complianceStatus;
        this.invoker = builder.invoker;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.reverseOrder = builder.reverseOrder;
    }

    public final String appArn() {
        return this.appArn;
    }

    public final String assessmentName() {
        return this.assessmentName;
    }

    public final List<AssessmentStatus> assessmentStatus() {
        return AssessmentStatusListCopier.copyStringToEnum(this.assessmentStatus);
    }

    public final boolean hasAssessmentStatus() {
        return this.assessmentStatus != null && !(this.assessmentStatus instanceof SdkAutoConstructList);
    }

    public final List<String> assessmentStatusAsStrings() {
        return this.assessmentStatus;
    }

    public final ComplianceStatus complianceStatus() {
        return ComplianceStatus.fromValue(this.complianceStatus);
    }

    public final String complianceStatusAsString() {
        return this.complianceStatus;
    }

    public final AssessmentInvoker invoker() {
        return AssessmentInvoker.fromValue(this.invoker);
    }

    public final String invokerAsString() {
        return this.invoker;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Boolean reverseOrder() {
        return this.reverseOrder;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.appArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.assessmentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssessmentStatus() ? this.assessmentStatusAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.complianceStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.invokerAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.reverseOrder());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAppAssessmentsRequest)) {
            return false;
        }
        ListAppAssessmentsRequest other = (ListAppAssessmentsRequest)((Object)obj);
        return Objects.equals(this.appArn(), other.appArn()) && Objects.equals(this.assessmentName(), other.assessmentName()) && this.hasAssessmentStatus() == other.hasAssessmentStatus() && Objects.equals(this.assessmentStatusAsStrings(), other.assessmentStatusAsStrings()) && Objects.equals(this.complianceStatusAsString(), other.complianceStatusAsString()) && Objects.equals(this.invokerAsString(), other.invokerAsString()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.reverseOrder(), other.reverseOrder());
    }

    public final String toString() {
        return ToString.builder((String)"ListAppAssessmentsRequest").add("AppArn", (Object)this.appArn()).add("AssessmentName", (Object)this.assessmentName()).add("AssessmentStatus", this.hasAssessmentStatus() ? this.assessmentStatusAsStrings() : null).add("ComplianceStatus", (Object)this.complianceStatusAsString()).add("Invoker", (Object)this.invokerAsString()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).add("ReverseOrder", (Object)this.reverseOrder()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "appArn": {
                return Optional.ofNullable(clazz.cast(this.appArn()));
            }
            case "assessmentName": {
                return Optional.ofNullable(clazz.cast(this.assessmentName()));
            }
            case "assessmentStatus": {
                return Optional.ofNullable(clazz.cast(this.assessmentStatusAsStrings()));
            }
            case "complianceStatus": {
                return Optional.ofNullable(clazz.cast(this.complianceStatusAsString()));
            }
            case "invoker": {
                return Optional.ofNullable(clazz.cast(this.invokerAsString()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "reverseOrder": {
                return Optional.ofNullable(clazz.cast(this.reverseOrder()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAppAssessmentsRequest, T> g) {
        return obj -> g.apply((ListAppAssessmentsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ResiliencehubRequest.BuilderImpl
    implements Builder {
        private String appArn;
        private String assessmentName;
        private List<String> assessmentStatus = DefaultSdkAutoConstructList.getInstance();
        private String complianceStatus;
        private String invoker;
        private Integer maxResults;
        private String nextToken;
        private Boolean reverseOrder;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAppAssessmentsRequest model) {
            super(model);
            this.appArn(model.appArn);
            this.assessmentName(model.assessmentName);
            this.assessmentStatusWithStrings(model.assessmentStatus);
            this.complianceStatus(model.complianceStatus);
            this.invoker(model.invoker);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.reverseOrder(model.reverseOrder);
        }

        public final String getAppArn() {
            return this.appArn;
        }

        public final void setAppArn(String appArn) {
            this.appArn = appArn;
        }

        @Override
        public final Builder appArn(String appArn) {
            this.appArn = appArn;
            return this;
        }

        public final String getAssessmentName() {
            return this.assessmentName;
        }

        public final void setAssessmentName(String assessmentName) {
            this.assessmentName = assessmentName;
        }

        @Override
        public final Builder assessmentName(String assessmentName) {
            this.assessmentName = assessmentName;
            return this;
        }

        public final Collection<String> getAssessmentStatus() {
            if (this.assessmentStatus instanceof SdkAutoConstructList) {
                return null;
            }
            return this.assessmentStatus;
        }

        public final void setAssessmentStatus(Collection<String> assessmentStatus) {
            this.assessmentStatus = AssessmentStatusListCopier.copy(assessmentStatus);
        }

        @Override
        public final Builder assessmentStatusWithStrings(Collection<String> assessmentStatus) {
            this.assessmentStatus = AssessmentStatusListCopier.copy(assessmentStatus);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assessmentStatusWithStrings(String ... assessmentStatus) {
            this.assessmentStatusWithStrings(Arrays.asList(assessmentStatus));
            return this;
        }

        @Override
        public final Builder assessmentStatus(Collection<AssessmentStatus> assessmentStatus) {
            this.assessmentStatus = AssessmentStatusListCopier.copyEnumToString(assessmentStatus);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assessmentStatus(AssessmentStatus ... assessmentStatus) {
            this.assessmentStatus(Arrays.asList(assessmentStatus));
            return this;
        }

        public final String getComplianceStatus() {
            return this.complianceStatus;
        }

        public final void setComplianceStatus(String complianceStatus) {
            this.complianceStatus = complianceStatus;
        }

        @Override
        public final Builder complianceStatus(String complianceStatus) {
            this.complianceStatus = complianceStatus;
            return this;
        }

        @Override
        public final Builder complianceStatus(ComplianceStatus complianceStatus) {
            this.complianceStatus(complianceStatus == null ? null : complianceStatus.toString());
            return this;
        }

        public final String getInvoker() {
            return this.invoker;
        }

        public final void setInvoker(String invoker) {
            this.invoker = invoker;
        }

        @Override
        public final Builder invoker(String invoker) {
            this.invoker = invoker;
            return this;
        }

        @Override
        public final Builder invoker(AssessmentInvoker invoker) {
            this.invoker(invoker == null ? null : invoker.toString());
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Boolean getReverseOrder() {
            return this.reverseOrder;
        }

        public final void setReverseOrder(Boolean reverseOrder) {
            this.reverseOrder = reverseOrder;
        }

        @Override
        public final Builder reverseOrder(Boolean reverseOrder) {
            this.reverseOrder = reverseOrder;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListAppAssessmentsRequest build() {
            return new ListAppAssessmentsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ResiliencehubRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAppAssessmentsRequest> {
        public Builder appArn(String var1);

        public Builder assessmentName(String var1);

        public Builder assessmentStatusWithStrings(Collection<String> var1);

        public Builder assessmentStatusWithStrings(String ... var1);

        public Builder assessmentStatus(Collection<AssessmentStatus> var1);

        public Builder assessmentStatus(AssessmentStatus ... var1);

        public Builder complianceStatus(String var1);

        public Builder complianceStatus(ComplianceStatus var1);

        public Builder invoker(String var1);

        public Builder invoker(AssessmentInvoker var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder reverseOrder(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

