/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.model;

import java.beans.Transient;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.resiliencehub.model.ResiliencehubResponse;
import software.amazon.awssdk.services.resiliencehub.model.ResourceImportStatusType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeDraftAppVersionResourcesImportStatusResponse
extends ResiliencehubResponse
implements ToCopyableBuilder<Builder, DescribeDraftAppVersionResourcesImportStatusResponse> {
    private static final SdkField<String> APP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("appArn").getter(DescribeDraftAppVersionResourcesImportStatusResponse.getter(DescribeDraftAppVersionResourcesImportStatusResponse::appArn)).setter(DescribeDraftAppVersionResourcesImportStatusResponse.setter(Builder::appArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appArn").build()}).build();
    private static final SdkField<String> APP_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("appVersion").getter(DescribeDraftAppVersionResourcesImportStatusResponse.getter(DescribeDraftAppVersionResourcesImportStatusResponse::appVersion)).setter(DescribeDraftAppVersionResourcesImportStatusResponse.setter(Builder::appVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appVersion").build()}).build();
    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("errorMessage").getter(DescribeDraftAppVersionResourcesImportStatusResponse.getter(DescribeDraftAppVersionResourcesImportStatusResponse::errorMessage)).setter(DescribeDraftAppVersionResourcesImportStatusResponse.setter(Builder::errorMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorMessage").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(DescribeDraftAppVersionResourcesImportStatusResponse.getter(DescribeDraftAppVersionResourcesImportStatusResponse::statusAsString)).setter(DescribeDraftAppVersionResourcesImportStatusResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Instant> STATUS_CHANGE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("statusChangeTime").getter(DescribeDraftAppVersionResourcesImportStatusResponse.getter(DescribeDraftAppVersionResourcesImportStatusResponse::statusChangeTime)).setter(DescribeDraftAppVersionResourcesImportStatusResponse.setter(Builder::statusChangeTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusChangeTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_ARN_FIELD, APP_VERSION_FIELD, ERROR_MESSAGE_FIELD, STATUS_FIELD, STATUS_CHANGE_TIME_FIELD));
    private final String appArn;
    private final String appVersion;
    private final String errorMessage;
    private final String status;
    private final Instant statusChangeTime;

    private DescribeDraftAppVersionResourcesImportStatusResponse(BuilderImpl builder) {
        super(builder);
        this.appArn = builder.appArn;
        this.appVersion = builder.appVersion;
        this.errorMessage = builder.errorMessage;
        this.status = builder.status;
        this.statusChangeTime = builder.statusChangeTime;
    }

    public final String appArn() {
        return this.appArn;
    }

    public final String appVersion() {
        return this.appVersion;
    }

    public final String errorMessage() {
        return this.errorMessage;
    }

    public final ResourceImportStatusType status() {
        return ResourceImportStatusType.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant statusChangeTime() {
        return this.statusChangeTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.appArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.appVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusChangeTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDraftAppVersionResourcesImportStatusResponse)) {
            return false;
        }
        DescribeDraftAppVersionResourcesImportStatusResponse other = (DescribeDraftAppVersionResourcesImportStatusResponse)((Object)obj);
        return Objects.equals(this.appArn(), other.appArn()) && Objects.equals(this.appVersion(), other.appVersion()) && Objects.equals(this.errorMessage(), other.errorMessage()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusChangeTime(), other.statusChangeTime());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeDraftAppVersionResourcesImportStatusResponse").add("AppArn", (Object)this.appArn()).add("AppVersion", (Object)this.appVersion()).add("ErrorMessage", (Object)this.errorMessage()).add("Status", (Object)this.statusAsString()).add("StatusChangeTime", (Object)this.statusChangeTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "appArn": {
                return Optional.ofNullable(clazz.cast(this.appArn()));
            }
            case "appVersion": {
                return Optional.ofNullable(clazz.cast(this.appVersion()));
            }
            case "errorMessage": {
                return Optional.ofNullable(clazz.cast(this.errorMessage()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "statusChangeTime": {
                return Optional.ofNullable(clazz.cast(this.statusChangeTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDraftAppVersionResourcesImportStatusResponse, T> g) {
        return obj -> g.apply((DescribeDraftAppVersionResourcesImportStatusResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ResiliencehubResponse.BuilderImpl
    implements Builder {
        private String appArn;
        private String appVersion;
        private String errorMessage;
        private String status;
        private Instant statusChangeTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDraftAppVersionResourcesImportStatusResponse model) {
            super(model);
            this.appArn(model.appArn);
            this.appVersion(model.appVersion);
            this.errorMessage(model.errorMessage);
            this.status(model.status);
            this.statusChangeTime(model.statusChangeTime);
        }

        public final String getAppArn() {
            return this.appArn;
        }

        public final void setAppArn(String appArn) {
            this.appArn = appArn;
        }

        @Override
        @Transient
        public final Builder appArn(String appArn) {
            this.appArn = appArn;
            return this;
        }

        public final String getAppVersion() {
            return this.appVersion;
        }

        public final void setAppVersion(String appVersion) {
            this.appVersion = appVersion;
        }

        @Override
        @Transient
        public final Builder appVersion(String appVersion) {
            this.appVersion = appVersion;
            return this;
        }

        public final String getErrorMessage() {
            return this.errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        @Transient
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(ResourceImportStatusType status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getStatusChangeTime() {
            return this.statusChangeTime;
        }

        public final void setStatusChangeTime(Instant statusChangeTime) {
            this.statusChangeTime = statusChangeTime;
        }

        @Override
        @Transient
        public final Builder statusChangeTime(Instant statusChangeTime) {
            this.statusChangeTime = statusChangeTime;
            return this;
        }

        @Override
        public DescribeDraftAppVersionResourcesImportStatusResponse build() {
            return new DescribeDraftAppVersionResourcesImportStatusResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ResiliencehubResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeDraftAppVersionResourcesImportStatusResponse> {
        public Builder appArn(String var1);

        public Builder appVersion(String var1);

        public Builder errorMessage(String var1);

        public Builder status(String var1);

        public Builder status(ResourceImportStatusType var1);

        public Builder statusChangeTime(Instant var1);
    }
}

