/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.resiliencehub.ResiliencehubAsyncClient;
import software.amazon.awssdk.services.resiliencehub.model.ListAppVersionResourceMappingsRequest;
import software.amazon.awssdk.services.resiliencehub.model.ListAppVersionResourceMappingsResponse;

public class ListAppVersionResourceMappingsPublisher
implements SdkPublisher<ListAppVersionResourceMappingsResponse> {
    private final ResiliencehubAsyncClient client;
    private final ListAppVersionResourceMappingsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAppVersionResourceMappingsPublisher(ResiliencehubAsyncClient client, ListAppVersionResourceMappingsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAppVersionResourceMappingsPublisher(ResiliencehubAsyncClient client, ListAppVersionResourceMappingsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAppVersionResourceMappingsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAppVersionResourceMappingsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListAppVersionResourceMappingsResponseFetcher
    implements AsyncPageFetcher<ListAppVersionResourceMappingsResponse> {
        private ListAppVersionResourceMappingsResponseFetcher() {
        }

        public boolean hasNextPage(ListAppVersionResourceMappingsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAppVersionResourceMappingsResponse> nextPage(ListAppVersionResourceMappingsResponse previousPage) {
            if (previousPage == null) {
                return ListAppVersionResourceMappingsPublisher.this.client.listAppVersionResourceMappings(ListAppVersionResourceMappingsPublisher.this.firstRequest);
            }
            return ListAppVersionResourceMappingsPublisher.this.client.listAppVersionResourceMappings((ListAppVersionResourceMappingsRequest)((Object)ListAppVersionResourceMappingsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

