/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.resiliencehub.model.RecommendationItem;
import software.amazon.awssdk.services.resiliencehub.model.RecommendationItemListCopier;
import software.amazon.awssdk.services.resiliencehub.model.SopServiceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SopRecommendation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SopRecommendation> {
    private static final SdkField<String> APP_COMPONENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("appComponentName").getter(SopRecommendation.getter(SopRecommendation::appComponentName)).setter(SopRecommendation.setter(Builder::appComponentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appComponentName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(SopRecommendation.getter(SopRecommendation::description)).setter(SopRecommendation.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<List<RecommendationItem>> ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("items").getter(SopRecommendation.getter(SopRecommendation::items)).setter(SopRecommendation.setter(Builder::items)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("items").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RecommendationItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(SopRecommendation.getter(SopRecommendation::name)).setter(SopRecommendation.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> PREREQUISITE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("prerequisite").getter(SopRecommendation.getter(SopRecommendation::prerequisite)).setter(SopRecommendation.setter(Builder::prerequisite)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("prerequisite").build()}).build();
    private static final SdkField<String> RECOMMENDATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("recommendationId").getter(SopRecommendation.getter(SopRecommendation::recommendationId)).setter(SopRecommendation.setter(Builder::recommendationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendationId").build()}).build();
    private static final SdkField<String> REFERENCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("referenceId").getter(SopRecommendation.getter(SopRecommendation::referenceId)).setter(SopRecommendation.setter(Builder::referenceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("referenceId").build()}).build();
    private static final SdkField<String> SERVICE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceType").getter(SopRecommendation.getter(SopRecommendation::serviceTypeAsString)).setter(SopRecommendation.setter(Builder::serviceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_COMPONENT_NAME_FIELD, DESCRIPTION_FIELD, ITEMS_FIELD, NAME_FIELD, PREREQUISITE_FIELD, RECOMMENDATION_ID_FIELD, REFERENCE_ID_FIELD, SERVICE_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String appComponentName;
    private final String description;
    private final List<RecommendationItem> items;
    private final String name;
    private final String prerequisite;
    private final String recommendationId;
    private final String referenceId;
    private final String serviceType;

    private SopRecommendation(BuilderImpl builder) {
        this.appComponentName = builder.appComponentName;
        this.description = builder.description;
        this.items = builder.items;
        this.name = builder.name;
        this.prerequisite = builder.prerequisite;
        this.recommendationId = builder.recommendationId;
        this.referenceId = builder.referenceId;
        this.serviceType = builder.serviceType;
    }

    public final String appComponentName() {
        return this.appComponentName;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasItems() {
        return this.items != null && !(this.items instanceof SdkAutoConstructList);
    }

    public final List<RecommendationItem> items() {
        return this.items;
    }

    public final String name() {
        return this.name;
    }

    public final String prerequisite() {
        return this.prerequisite;
    }

    public final String recommendationId() {
        return this.recommendationId;
    }

    public final String referenceId() {
        return this.referenceId;
    }

    public final SopServiceType serviceType() {
        return SopServiceType.fromValue(this.serviceType);
    }

    public final String serviceTypeAsString() {
        return this.serviceType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.appComponentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasItems() ? this.items() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.prerequisite());
        hashCode = 31 * hashCode + Objects.hashCode(this.recommendationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.referenceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SopRecommendation)) {
            return false;
        }
        SopRecommendation other = (SopRecommendation)obj;
        return Objects.equals(this.appComponentName(), other.appComponentName()) && Objects.equals(this.description(), other.description()) && this.hasItems() == other.hasItems() && Objects.equals(this.items(), other.items()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.prerequisite(), other.prerequisite()) && Objects.equals(this.recommendationId(), other.recommendationId()) && Objects.equals(this.referenceId(), other.referenceId()) && Objects.equals(this.serviceTypeAsString(), other.serviceTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"SopRecommendation").add("AppComponentName", (Object)this.appComponentName()).add("Description", (Object)this.description()).add("Items", this.hasItems() ? this.items() : null).add("Name", (Object)this.name()).add("Prerequisite", (Object)this.prerequisite()).add("RecommendationId", (Object)this.recommendationId()).add("ReferenceId", (Object)this.referenceId()).add("ServiceType", (Object)this.serviceTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "appComponentName": {
                return Optional.ofNullable(clazz.cast(this.appComponentName()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "items": {
                return Optional.ofNullable(clazz.cast(this.items()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "prerequisite": {
                return Optional.ofNullable(clazz.cast(this.prerequisite()));
            }
            case "recommendationId": {
                return Optional.ofNullable(clazz.cast(this.recommendationId()));
            }
            case "referenceId": {
                return Optional.ofNullable(clazz.cast(this.referenceId()));
            }
            case "serviceType": {
                return Optional.ofNullable(clazz.cast(this.serviceTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SopRecommendation, T> g) {
        return obj -> g.apply((SopRecommendation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String appComponentName;
        private String description;
        private List<RecommendationItem> items = DefaultSdkAutoConstructList.getInstance();
        private String name;
        private String prerequisite;
        private String recommendationId;
        private String referenceId;
        private String serviceType;

        private BuilderImpl() {
        }

        private BuilderImpl(SopRecommendation model) {
            this.appComponentName(model.appComponentName);
            this.description(model.description);
            this.items(model.items);
            this.name(model.name);
            this.prerequisite(model.prerequisite);
            this.recommendationId(model.recommendationId);
            this.referenceId(model.referenceId);
            this.serviceType(model.serviceType);
        }

        public final String getAppComponentName() {
            return this.appComponentName;
        }

        public final void setAppComponentName(String appComponentName) {
            this.appComponentName = appComponentName;
        }

        @Override
        @Transient
        public final Builder appComponentName(String appComponentName) {
            this.appComponentName = appComponentName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<RecommendationItem.Builder> getItems() {
            List<RecommendationItem.Builder> result = RecommendationItemListCopier.copyToBuilder(this.items);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setItems(Collection<RecommendationItem.BuilderImpl> items) {
            this.items = RecommendationItemListCopier.copyFromBuilder(items);
        }

        @Override
        @Transient
        public final Builder items(Collection<RecommendationItem> items) {
            this.items = RecommendationItemListCopier.copy(items);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder items(RecommendationItem ... items) {
            this.items(Arrays.asList(items));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder items(Consumer<RecommendationItem.Builder> ... items) {
            this.items(Stream.of(items).map(c -> (RecommendationItem)((RecommendationItem.Builder)RecommendationItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getPrerequisite() {
            return this.prerequisite;
        }

        public final void setPrerequisite(String prerequisite) {
            this.prerequisite = prerequisite;
        }

        @Override
        @Transient
        public final Builder prerequisite(String prerequisite) {
            this.prerequisite = prerequisite;
            return this;
        }

        public final String getRecommendationId() {
            return this.recommendationId;
        }

        public final void setRecommendationId(String recommendationId) {
            this.recommendationId = recommendationId;
        }

        @Override
        @Transient
        public final Builder recommendationId(String recommendationId) {
            this.recommendationId = recommendationId;
            return this;
        }

        public final String getReferenceId() {
            return this.referenceId;
        }

        public final void setReferenceId(String referenceId) {
            this.referenceId = referenceId;
        }

        @Override
        @Transient
        public final Builder referenceId(String referenceId) {
            this.referenceId = referenceId;
            return this;
        }

        public final String getServiceType() {
            return this.serviceType;
        }

        public final void setServiceType(String serviceType) {
            this.serviceType = serviceType;
        }

        @Override
        @Transient
        public final Builder serviceType(String serviceType) {
            this.serviceType = serviceType;
            return this;
        }

        @Override
        @Transient
        public final Builder serviceType(SopServiceType serviceType) {
            this.serviceType(serviceType == null ? null : serviceType.toString());
            return this;
        }

        public SopRecommendation build() {
            return new SopRecommendation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SopRecommendation> {
        public Builder appComponentName(String var1);

        public Builder description(String var1);

        public Builder items(Collection<RecommendationItem> var1);

        public Builder items(RecommendationItem ... var1);

        public Builder items(Consumer<RecommendationItem.Builder> ... var1);

        public Builder name(String var1);

        public Builder prerequisite(String var1);

        public Builder recommendationId(String var1);

        public Builder referenceId(String var1);

        public Builder serviceType(String var1);

        public Builder serviceType(SopServiceType var1);
    }
}

