/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.resiliencehub.model.AppComponent;
import software.amazon.awssdk.services.resiliencehub.model.AppComponentListCopier;
import software.amazon.awssdk.services.resiliencehub.model.LogicalResourceId;
import software.amazon.awssdk.services.resiliencehub.model.PhysicalResourceId;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PhysicalResource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PhysicalResource> {
    private static final SdkField<List<AppComponent>> APP_COMPONENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("appComponents").getter(PhysicalResource.getter(PhysicalResource::appComponents)).setter(PhysicalResource.setter(Builder::appComponents)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appComponents").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AppComponent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<LogicalResourceId> LOGICAL_RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("logicalResourceId").getter(PhysicalResource.getter(PhysicalResource::logicalResourceId)).setter(PhysicalResource.setter(Builder::logicalResourceId)).constructor(LogicalResourceId::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logicalResourceId").build()}).build();
    private static final SdkField<PhysicalResourceId> PHYSICAL_RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("physicalResourceId").getter(PhysicalResource.getter(PhysicalResource::physicalResourceId)).setter(PhysicalResource.setter(Builder::physicalResourceId)).constructor(PhysicalResourceId::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("physicalResourceId").build()}).build();
    private static final SdkField<String> RESOURCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceName").getter(PhysicalResource.getter(PhysicalResource::resourceName)).setter(PhysicalResource.setter(Builder::resourceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceName").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceType").getter(PhysicalResource.getter(PhysicalResource::resourceType)).setter(PhysicalResource.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_COMPONENTS_FIELD, LOGICAL_RESOURCE_ID_FIELD, PHYSICAL_RESOURCE_ID_FIELD, RESOURCE_NAME_FIELD, RESOURCE_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<AppComponent> appComponents;
    private final LogicalResourceId logicalResourceId;
    private final PhysicalResourceId physicalResourceId;
    private final String resourceName;
    private final String resourceType;

    private PhysicalResource(BuilderImpl builder) {
        this.appComponents = builder.appComponents;
        this.logicalResourceId = builder.logicalResourceId;
        this.physicalResourceId = builder.physicalResourceId;
        this.resourceName = builder.resourceName;
        this.resourceType = builder.resourceType;
    }

    public final boolean hasAppComponents() {
        return this.appComponents != null && !(this.appComponents instanceof SdkAutoConstructList);
    }

    public final List<AppComponent> appComponents() {
        return this.appComponents;
    }

    public final LogicalResourceId logicalResourceId() {
        return this.logicalResourceId;
    }

    public final PhysicalResourceId physicalResourceId() {
        return this.physicalResourceId;
    }

    public final String resourceName() {
        return this.resourceName;
    }

    public final String resourceType() {
        return this.resourceType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAppComponents() ? this.appComponents() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.logicalResourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.physicalResourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceType());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PhysicalResource)) {
            return false;
        }
        PhysicalResource other = (PhysicalResource)obj;
        return this.hasAppComponents() == other.hasAppComponents() && Objects.equals(this.appComponents(), other.appComponents()) && Objects.equals(this.logicalResourceId(), other.logicalResourceId()) && Objects.equals(this.physicalResourceId(), other.physicalResourceId()) && Objects.equals(this.resourceName(), other.resourceName()) && Objects.equals(this.resourceType(), other.resourceType());
    }

    public final String toString() {
        return ToString.builder((String)"PhysicalResource").add("AppComponents", this.hasAppComponents() ? this.appComponents() : null).add("LogicalResourceId", (Object)this.logicalResourceId()).add("PhysicalResourceId", (Object)this.physicalResourceId()).add("ResourceName", (Object)this.resourceName()).add("ResourceType", (Object)this.resourceType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "appComponents": {
                return Optional.ofNullable(clazz.cast(this.appComponents()));
            }
            case "logicalResourceId": {
                return Optional.ofNullable(clazz.cast(this.logicalResourceId()));
            }
            case "physicalResourceId": {
                return Optional.ofNullable(clazz.cast(this.physicalResourceId()));
            }
            case "resourceName": {
                return Optional.ofNullable(clazz.cast(this.resourceName()));
            }
            case "resourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceType()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PhysicalResource, T> g) {
        return obj -> g.apply((PhysicalResource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<AppComponent> appComponents = DefaultSdkAutoConstructList.getInstance();
        private LogicalResourceId logicalResourceId;
        private PhysicalResourceId physicalResourceId;
        private String resourceName;
        private String resourceType;

        private BuilderImpl() {
        }

        private BuilderImpl(PhysicalResource model) {
            this.appComponents(model.appComponents);
            this.logicalResourceId(model.logicalResourceId);
            this.physicalResourceId(model.physicalResourceId);
            this.resourceName(model.resourceName);
            this.resourceType(model.resourceType);
        }

        public final List<AppComponent.Builder> getAppComponents() {
            List<AppComponent.Builder> result = AppComponentListCopier.copyToBuilder(this.appComponents);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAppComponents(Collection<AppComponent.BuilderImpl> appComponents) {
            this.appComponents = AppComponentListCopier.copyFromBuilder(appComponents);
        }

        @Override
        @Transient
        public final Builder appComponents(Collection<AppComponent> appComponents) {
            this.appComponents = AppComponentListCopier.copy(appComponents);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder appComponents(AppComponent ... appComponents) {
            this.appComponents(Arrays.asList(appComponents));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder appComponents(Consumer<AppComponent.Builder> ... appComponents) {
            this.appComponents(Stream.of(appComponents).map(c -> (AppComponent)((AppComponent.Builder)AppComponent.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final LogicalResourceId.Builder getLogicalResourceId() {
            return this.logicalResourceId != null ? this.logicalResourceId.toBuilder() : null;
        }

        public final void setLogicalResourceId(LogicalResourceId.BuilderImpl logicalResourceId) {
            this.logicalResourceId = logicalResourceId != null ? logicalResourceId.build() : null;
        }

        @Override
        @Transient
        public final Builder logicalResourceId(LogicalResourceId logicalResourceId) {
            this.logicalResourceId = logicalResourceId;
            return this;
        }

        public final PhysicalResourceId.Builder getPhysicalResourceId() {
            return this.physicalResourceId != null ? this.physicalResourceId.toBuilder() : null;
        }

        public final void setPhysicalResourceId(PhysicalResourceId.BuilderImpl physicalResourceId) {
            this.physicalResourceId = physicalResourceId != null ? physicalResourceId.build() : null;
        }

        @Override
        @Transient
        public final Builder physicalResourceId(PhysicalResourceId physicalResourceId) {
            this.physicalResourceId = physicalResourceId;
            return this;
        }

        public final String getResourceName() {
            return this.resourceName;
        }

        public final void setResourceName(String resourceName) {
            this.resourceName = resourceName;
        }

        @Override
        @Transient
        public final Builder resourceName(String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        @Transient
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public PhysicalResource build() {
            return new PhysicalResource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PhysicalResource> {
        public Builder appComponents(Collection<AppComponent> var1);

        public Builder appComponents(AppComponent ... var1);

        public Builder appComponents(Consumer<AppComponent.Builder> ... var1);

        public Builder logicalResourceId(LogicalResourceId var1);

        default public Builder logicalResourceId(Consumer<LogicalResourceId.Builder> logicalResourceId) {
            return this.logicalResourceId((LogicalResourceId)((LogicalResourceId.Builder)LogicalResourceId.builder().applyMutation(logicalResourceId)).build());
        }

        public Builder physicalResourceId(PhysicalResourceId var1);

        default public Builder physicalResourceId(Consumer<PhysicalResourceId.Builder> physicalResourceId) {
            return this.physicalResourceId((PhysicalResourceId)((PhysicalResourceId.Builder)PhysicalResourceId.builder().applyMutation(physicalResourceId)).build());
        }

        public Builder resourceName(String var1);

        public Builder resourceType(String var1);
    }
}

