/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ResourceMappingType {
    CFN_STACK("CfnStack"),
    RESOURCE("Resource"),
    APP_REGISTRY_APP("AppRegistryApp"),
    RESOURCE_GROUP("ResourceGroup"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ResourceMappingType> VALUE_MAP;
    private final String value;

    private ResourceMappingType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ResourceMappingType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ResourceMappingType> knownValues() {
        EnumSet<ResourceMappingType> knownValues = EnumSet.allOf(ResourceMappingType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ResourceMappingType.class, ResourceMappingType::toString);
    }
}

