/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.resiliencehub.model.AppComplianceStatusType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AppSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AppSummary> {
    private static final SdkField<String> APP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("appArn").getter(AppSummary.getter(AppSummary::appArn)).setter(AppSummary.setter(Builder::appArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appArn").build()}).build();
    private static final SdkField<String> COMPLIANCE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("complianceStatus").getter(AppSummary.getter(AppSummary::complianceStatusAsString)).setter(AppSummary.setter(Builder::complianceStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("complianceStatus").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTime").getter(AppSummary.getter(AppSummary::creationTime)).setter(AppSummary.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(AppSummary.getter(AppSummary::description)).setter(AppSummary.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(AppSummary.getter(AppSummary::name)).setter(AppSummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<Double> RESILIENCY_SCORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("resiliencyScore").getter(AppSummary.getter(AppSummary::resiliencyScore)).setter(AppSummary.setter(Builder::resiliencyScore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resiliencyScore").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_ARN_FIELD, COMPLIANCE_STATUS_FIELD, CREATION_TIME_FIELD, DESCRIPTION_FIELD, NAME_FIELD, RESILIENCY_SCORE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String appArn;
    private final String complianceStatus;
    private final Instant creationTime;
    private final String description;
    private final String name;
    private final Double resiliencyScore;

    private AppSummary(BuilderImpl builder) {
        this.appArn = builder.appArn;
        this.complianceStatus = builder.complianceStatus;
        this.creationTime = builder.creationTime;
        this.description = builder.description;
        this.name = builder.name;
        this.resiliencyScore = builder.resiliencyScore;
    }

    public final String appArn() {
        return this.appArn;
    }

    public final AppComplianceStatusType complianceStatus() {
        return AppComplianceStatusType.fromValue(this.complianceStatus);
    }

    public final String complianceStatusAsString() {
        return this.complianceStatus;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final String description() {
        return this.description;
    }

    public final String name() {
        return this.name;
    }

    public final Double resiliencyScore() {
        return this.resiliencyScore;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.appArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.complianceStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.resiliencyScore());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AppSummary)) {
            return false;
        }
        AppSummary other = (AppSummary)obj;
        return Objects.equals(this.appArn(), other.appArn()) && Objects.equals(this.complianceStatusAsString(), other.complianceStatusAsString()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.resiliencyScore(), other.resiliencyScore());
    }

    public final String toString() {
        return ToString.builder((String)"AppSummary").add("AppArn", (Object)this.appArn()).add("ComplianceStatus", (Object)this.complianceStatusAsString()).add("CreationTime", (Object)this.creationTime()).add("Description", (Object)this.description()).add("Name", (Object)this.name()).add("ResiliencyScore", (Object)this.resiliencyScore()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "appArn": {
                return Optional.ofNullable(clazz.cast(this.appArn()));
            }
            case "complianceStatus": {
                return Optional.ofNullable(clazz.cast(this.complianceStatusAsString()));
            }
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "resiliencyScore": {
                return Optional.ofNullable(clazz.cast(this.resiliencyScore()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AppSummary, T> g) {
        return obj -> g.apply((AppSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String appArn;
        private String complianceStatus;
        private Instant creationTime;
        private String description;
        private String name;
        private Double resiliencyScore;

        private BuilderImpl() {
        }

        private BuilderImpl(AppSummary model) {
            this.appArn(model.appArn);
            this.complianceStatus(model.complianceStatus);
            this.creationTime(model.creationTime);
            this.description(model.description);
            this.name(model.name);
            this.resiliencyScore(model.resiliencyScore);
        }

        public final String getAppArn() {
            return this.appArn;
        }

        public final void setAppArn(String appArn) {
            this.appArn = appArn;
        }

        @Override
        public final Builder appArn(String appArn) {
            this.appArn = appArn;
            return this;
        }

        public final String getComplianceStatus() {
            return this.complianceStatus;
        }

        public final void setComplianceStatus(String complianceStatus) {
            this.complianceStatus = complianceStatus;
        }

        @Override
        public final Builder complianceStatus(String complianceStatus) {
            this.complianceStatus = complianceStatus;
            return this;
        }

        @Override
        public final Builder complianceStatus(AppComplianceStatusType complianceStatus) {
            this.complianceStatus(complianceStatus == null ? null : complianceStatus.toString());
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Double getResiliencyScore() {
            return this.resiliencyScore;
        }

        public final void setResiliencyScore(Double resiliencyScore) {
            this.resiliencyScore = resiliencyScore;
        }

        @Override
        public final Builder resiliencyScore(Double resiliencyScore) {
            this.resiliencyScore = resiliencyScore;
            return this;
        }

        public AppSummary build() {
            return new AppSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AppSummary> {
        public Builder appArn(String var1);

        public Builder complianceStatus(String var1);

        public Builder complianceStatus(AppComplianceStatusType var1);

        public Builder creationTime(Instant var1);

        public Builder description(String var1);

        public Builder name(String var1);

        public Builder resiliencyScore(Double var1);
    }
}

