/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.resiliencehub.model.CostFrequency;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Cost
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Cost> {
    private static final SdkField<Double> AMOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("amount").getter(Cost.getter(Cost::amount)).setter(Cost.setter(Builder::amount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("amount").build()}).build();
    private static final SdkField<String> CURRENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("currency").getter(Cost.getter(Cost::currency)).setter(Cost.setter(Builder::currency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currency").build()}).build();
    private static final SdkField<String> FREQUENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("frequency").getter(Cost.getter(Cost::frequencyAsString)).setter(Cost.setter(Builder::frequency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("frequency").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AMOUNT_FIELD, CURRENCY_FIELD, FREQUENCY_FIELD));
    private static final long serialVersionUID = 1L;
    private final Double amount;
    private final String currency;
    private final String frequency;

    private Cost(BuilderImpl builder) {
        this.amount = builder.amount;
        this.currency = builder.currency;
        this.frequency = builder.frequency;
    }

    public final Double amount() {
        return this.amount;
    }

    public final String currency() {
        return this.currency;
    }

    public final CostFrequency frequency() {
        return CostFrequency.fromValue(this.frequency);
    }

    public final String frequencyAsString() {
        return this.frequency;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.amount());
        hashCode = 31 * hashCode + Objects.hashCode(this.currency());
        hashCode = 31 * hashCode + Objects.hashCode(this.frequencyAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Cost)) {
            return false;
        }
        Cost other = (Cost)obj;
        return Objects.equals(this.amount(), other.amount()) && Objects.equals(this.currency(), other.currency()) && Objects.equals(this.frequencyAsString(), other.frequencyAsString());
    }

    public final String toString() {
        return ToString.builder((String)"Cost").add("Amount", (Object)this.amount()).add("Currency", (Object)this.currency()).add("Frequency", (Object)this.frequencyAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "amount": {
                return Optional.ofNullable(clazz.cast(this.amount()));
            }
            case "currency": {
                return Optional.ofNullable(clazz.cast(this.currency()));
            }
            case "frequency": {
                return Optional.ofNullable(clazz.cast(this.frequencyAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Cost, T> g) {
        return obj -> g.apply((Cost)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Double amount;
        private String currency;
        private String frequency;

        private BuilderImpl() {
        }

        private BuilderImpl(Cost model) {
            this.amount(model.amount);
            this.currency(model.currency);
            this.frequency(model.frequency);
        }

        public final Double getAmount() {
            return this.amount;
        }

        public final void setAmount(Double amount) {
            this.amount = amount;
        }

        @Override
        @Transient
        public final Builder amount(Double amount) {
            this.amount = amount;
            return this;
        }

        public final String getCurrency() {
            return this.currency;
        }

        public final void setCurrency(String currency) {
            this.currency = currency;
        }

        @Override
        @Transient
        public final Builder currency(String currency) {
            this.currency = currency;
            return this;
        }

        public final String getFrequency() {
            return this.frequency;
        }

        public final void setFrequency(String frequency) {
            this.frequency = frequency;
        }

        @Override
        @Transient
        public final Builder frequency(String frequency) {
            this.frequency = frequency;
            return this;
        }

        @Override
        @Transient
        public final Builder frequency(CostFrequency frequency) {
            this.frequency(frequency == null ? null : frequency.toString());
            return this;
        }

        public Cost build() {
            return new Cost(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Cost> {
        public Builder amount(Double var1);

        public Builder currency(String var1);

        public Builder frequency(String var1);

        public Builder frequency(CostFrequency var1);
    }
}

