/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.resiliencehub.model.ArnListCopier;
import software.amazon.awssdk.services.resiliencehub.model.ResiliencehubRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImportResourcesToDraftAppVersionRequest
extends ResiliencehubRequest
implements ToCopyableBuilder<Builder, ImportResourcesToDraftAppVersionRequest> {
    private static final SdkField<String> APP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("appArn").getter(ImportResourcesToDraftAppVersionRequest.getter(ImportResourcesToDraftAppVersionRequest::appArn)).setter(ImportResourcesToDraftAppVersionRequest.setter(Builder::appArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appArn").build()}).build();
    private static final SdkField<List<String>> SOURCE_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("sourceArns").getter(ImportResourcesToDraftAppVersionRequest.getter(ImportResourcesToDraftAppVersionRequest::sourceArns)).setter(ImportResourcesToDraftAppVersionRequest.setter(Builder::sourceArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_ARN_FIELD, SOURCE_ARNS_FIELD));
    private final String appArn;
    private final List<String> sourceArns;

    private ImportResourcesToDraftAppVersionRequest(BuilderImpl builder) {
        super(builder);
        this.appArn = builder.appArn;
        this.sourceArns = builder.sourceArns;
    }

    public final String appArn() {
        return this.appArn;
    }

    public final boolean hasSourceArns() {
        return this.sourceArns != null && !(this.sourceArns instanceof SdkAutoConstructList);
    }

    public final List<String> sourceArns() {
        return this.sourceArns;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.appArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSourceArns() ? this.sourceArns() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportResourcesToDraftAppVersionRequest)) {
            return false;
        }
        ImportResourcesToDraftAppVersionRequest other = (ImportResourcesToDraftAppVersionRequest)((Object)obj);
        return Objects.equals(this.appArn(), other.appArn()) && this.hasSourceArns() == other.hasSourceArns() && Objects.equals(this.sourceArns(), other.sourceArns());
    }

    public final String toString() {
        return ToString.builder((String)"ImportResourcesToDraftAppVersionRequest").add("AppArn", (Object)this.appArn()).add("SourceArns", this.hasSourceArns() ? this.sourceArns() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "appArn": {
                return Optional.ofNullable(clazz.cast(this.appArn()));
            }
            case "sourceArns": {
                return Optional.ofNullable(clazz.cast(this.sourceArns()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImportResourcesToDraftAppVersionRequest, T> g) {
        return obj -> g.apply((ImportResourcesToDraftAppVersionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ResiliencehubRequest.BuilderImpl
    implements Builder {
        private String appArn;
        private List<String> sourceArns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ImportResourcesToDraftAppVersionRequest model) {
            super(model);
            this.appArn(model.appArn);
            this.sourceArns(model.sourceArns);
        }

        public final String getAppArn() {
            return this.appArn;
        }

        public final void setAppArn(String appArn) {
            this.appArn = appArn;
        }

        @Override
        @Transient
        public final Builder appArn(String appArn) {
            this.appArn = appArn;
            return this;
        }

        public final Collection<String> getSourceArns() {
            if (this.sourceArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.sourceArns;
        }

        public final void setSourceArns(Collection<String> sourceArns) {
            this.sourceArns = ArnListCopier.copy(sourceArns);
        }

        @Override
        @Transient
        public final Builder sourceArns(Collection<String> sourceArns) {
            this.sourceArns = ArnListCopier.copy(sourceArns);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder sourceArns(String ... sourceArns) {
            this.sourceArns(Arrays.asList(sourceArns));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ImportResourcesToDraftAppVersionRequest build() {
            return new ImportResourcesToDraftAppVersionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ResiliencehubRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ImportResourcesToDraftAppVersionRequest> {
        public Builder appArn(String var1);

        public Builder sourceArns(Collection<String> var1);

        public Builder sourceArns(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

