/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.resiliencehub.model.RecommendationTemplateStatus;
import software.amazon.awssdk.services.resiliencehub.model.ResiliencehubResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteRecommendationTemplateResponse
extends ResiliencehubResponse
implements ToCopyableBuilder<Builder, DeleteRecommendationTemplateResponse> {
    private static final SdkField<String> RECOMMENDATION_TEMPLATE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("recommendationTemplateArn").getter(DeleteRecommendationTemplateResponse.getter(DeleteRecommendationTemplateResponse::recommendationTemplateArn)).setter(DeleteRecommendationTemplateResponse.setter(Builder::recommendationTemplateArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendationTemplateArn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(DeleteRecommendationTemplateResponse.getter(DeleteRecommendationTemplateResponse::statusAsString)).setter(DeleteRecommendationTemplateResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECOMMENDATION_TEMPLATE_ARN_FIELD, STATUS_FIELD));
    private final String recommendationTemplateArn;
    private final String status;

    private DeleteRecommendationTemplateResponse(BuilderImpl builder) {
        super(builder);
        this.recommendationTemplateArn = builder.recommendationTemplateArn;
        this.status = builder.status;
    }

    public final String recommendationTemplateArn() {
        return this.recommendationTemplateArn;
    }

    public final RecommendationTemplateStatus status() {
        return RecommendationTemplateStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.recommendationTemplateArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteRecommendationTemplateResponse)) {
            return false;
        }
        DeleteRecommendationTemplateResponse other = (DeleteRecommendationTemplateResponse)((Object)obj);
        return Objects.equals(this.recommendationTemplateArn(), other.recommendationTemplateArn()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteRecommendationTemplateResponse").add("RecommendationTemplateArn", (Object)this.recommendationTemplateArn()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "recommendationTemplateArn": {
                return Optional.ofNullable(clazz.cast(this.recommendationTemplateArn()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteRecommendationTemplateResponse, T> g) {
        return obj -> g.apply((DeleteRecommendationTemplateResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ResiliencehubResponse.BuilderImpl
    implements Builder {
        private String recommendationTemplateArn;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteRecommendationTemplateResponse model) {
            super(model);
            this.recommendationTemplateArn(model.recommendationTemplateArn);
            this.status(model.status);
        }

        public final String getRecommendationTemplateArn() {
            return this.recommendationTemplateArn;
        }

        public final void setRecommendationTemplateArn(String recommendationTemplateArn) {
            this.recommendationTemplateArn = recommendationTemplateArn;
        }

        @Override
        @Transient
        public final Builder recommendationTemplateArn(String recommendationTemplateArn) {
            this.recommendationTemplateArn = recommendationTemplateArn;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(RecommendationTemplateStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public DeleteRecommendationTemplateResponse build() {
            return new DeleteRecommendationTemplateResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ResiliencehubResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteRecommendationTemplateResponse> {
        public Builder recommendationTemplateArn(String var1);

        public Builder status(String var1);

        public Builder status(RecommendationTemplateStatus var1);
    }
}

