/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.resiliencehub.model.ResiliencehubResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutDraftAppVersionTemplateResponse
extends ResiliencehubResponse
implements ToCopyableBuilder<Builder, PutDraftAppVersionTemplateResponse> {
    private static final SdkField<String> APP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("appArn").getter(PutDraftAppVersionTemplateResponse.getter(PutDraftAppVersionTemplateResponse::appArn)).setter(PutDraftAppVersionTemplateResponse.setter(Builder::appArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appArn").build()}).build();
    private static final SdkField<String> APP_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("appVersion").getter(PutDraftAppVersionTemplateResponse.getter(PutDraftAppVersionTemplateResponse::appVersion)).setter(PutDraftAppVersionTemplateResponse.setter(Builder::appVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_ARN_FIELD, APP_VERSION_FIELD));
    private final String appArn;
    private final String appVersion;

    private PutDraftAppVersionTemplateResponse(BuilderImpl builder) {
        super(builder);
        this.appArn = builder.appArn;
        this.appVersion = builder.appVersion;
    }

    public final String appArn() {
        return this.appArn;
    }

    public final String appVersion() {
        return this.appVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.appArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.appVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutDraftAppVersionTemplateResponse)) {
            return false;
        }
        PutDraftAppVersionTemplateResponse other = (PutDraftAppVersionTemplateResponse)((Object)obj);
        return Objects.equals(this.appArn(), other.appArn()) && Objects.equals(this.appVersion(), other.appVersion());
    }

    public final String toString() {
        return ToString.builder((String)"PutDraftAppVersionTemplateResponse").add("AppArn", (Object)this.appArn()).add("AppVersion", (Object)this.appVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "appArn": {
                return Optional.ofNullable(clazz.cast(this.appArn()));
            }
            case "appVersion": {
                return Optional.ofNullable(clazz.cast(this.appVersion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutDraftAppVersionTemplateResponse, T> g) {
        return obj -> g.apply((PutDraftAppVersionTemplateResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ResiliencehubResponse.BuilderImpl
    implements Builder {
        private String appArn;
        private String appVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(PutDraftAppVersionTemplateResponse model) {
            super(model);
            this.appArn(model.appArn);
            this.appVersion(model.appVersion);
        }

        public final String getAppArn() {
            return this.appArn;
        }

        public final void setAppArn(String appArn) {
            this.appArn = appArn;
        }

        @Override
        @Transient
        public final Builder appArn(String appArn) {
            this.appArn = appArn;
            return this;
        }

        public final String getAppVersion() {
            return this.appVersion;
        }

        public final void setAppVersion(String appVersion) {
            this.appVersion = appVersion;
        }

        @Override
        @Transient
        public final Builder appVersion(String appVersion) {
            this.appVersion = appVersion;
            return this;
        }

        @Override
        public PutDraftAppVersionTemplateResponse build() {
            return new PutDraftAppVersionTemplateResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ResiliencehubResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutDraftAppVersionTemplateResponse> {
        public Builder appArn(String var1);

        public Builder appVersion(String var1);
    }
}

