/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.repostspace.waiters;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.internal.waiters.WaiterAttribute;
import software.amazon.awssdk.core.waiters.AsyncWaiter;
import software.amazon.awssdk.core.waiters.WaiterAcceptor;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.retries.api.BackoffStrategy;
import software.amazon.awssdk.services.repostspace.RepostspaceAsyncClient;
import software.amazon.awssdk.services.repostspace.jmespath.internal.JmesPathRuntime;
import software.amazon.awssdk.services.repostspace.model.GetChannelRequest;
import software.amazon.awssdk.services.repostspace.model.GetChannelResponse;
import software.amazon.awssdk.services.repostspace.model.GetSpaceRequest;
import software.amazon.awssdk.services.repostspace.model.GetSpaceResponse;
import software.amazon.awssdk.services.repostspace.model.RepostspaceRequest;
import software.amazon.awssdk.services.repostspace.waiters.RepostspaceAsyncWaiter;
import software.amazon.awssdk.services.repostspace.waiters.internal.WaitersRuntime;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.SdkAutoCloseable;
import software.amazon.awssdk.utils.ThreadFactoryBuilder;

@SdkInternalApi
@ThreadSafe
final class DefaultRepostspaceAsyncWaiter
implements RepostspaceAsyncWaiter {
    private static final WaiterAttribute<SdkAutoCloseable> CLIENT_ATTRIBUTE = new WaiterAttribute(SdkAutoCloseable.class);
    private static final WaiterAttribute<ScheduledExecutorService> SCHEDULED_EXECUTOR_SERVICE_ATTRIBUTE = new WaiterAttribute(ScheduledExecutorService.class);
    private final RepostspaceAsyncClient client;
    private final AttributeMap managedResources;
    private final AsyncWaiter<GetChannelResponse> channelCreatedWaiter;
    private final AsyncWaiter<GetChannelResponse> channelDeletedWaiter;
    private final AsyncWaiter<GetSpaceResponse> spaceCreatedWaiter;
    private final AsyncWaiter<GetSpaceResponse> spaceDeletedWaiter;
    private final ScheduledExecutorService executorService;

    private DefaultRepostspaceAsyncWaiter(DefaultBuilder builder) {
        AttributeMap.Builder attributeMapBuilder = AttributeMap.builder();
        if (builder.client == null) {
            this.client = (RepostspaceAsyncClient)RepostspaceAsyncClient.builder().build();
            attributeMapBuilder.put(CLIENT_ATTRIBUTE, (Object)this.client);
        } else {
            this.client = builder.client;
        }
        if (builder.executorService == null) {
            this.executorService = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().threadNamePrefix("waiters-ScheduledExecutor").build());
            attributeMapBuilder.put(SCHEDULED_EXECUTOR_SERVICE_ATTRIBUTE, (Object)this.executorService);
        } else {
            this.executorService = builder.executorService;
        }
        this.managedResources = attributeMapBuilder.build();
        this.channelCreatedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(GetChannelResponse.class).acceptors(DefaultRepostspaceAsyncWaiter.channelCreatedWaiterAcceptors())).overrideConfiguration(DefaultRepostspaceAsyncWaiter.channelCreatedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.channelDeletedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(GetChannelResponse.class).acceptors(DefaultRepostspaceAsyncWaiter.channelDeletedWaiterAcceptors())).overrideConfiguration(DefaultRepostspaceAsyncWaiter.channelDeletedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.spaceCreatedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(GetSpaceResponse.class).acceptors(DefaultRepostspaceAsyncWaiter.spaceCreatedWaiterAcceptors())).overrideConfiguration(DefaultRepostspaceAsyncWaiter.spaceCreatedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.spaceDeletedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(GetSpaceResponse.class).acceptors(DefaultRepostspaceAsyncWaiter.spaceDeletedWaiterAcceptors())).overrideConfiguration(DefaultRepostspaceAsyncWaiter.spaceDeletedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
    }

    private static String errorCode(Throwable error) {
        if (error instanceof AwsServiceException) {
            return ((AwsServiceException)error).awsErrorDetails().errorCode();
        }
        return null;
    }

    @Override
    public CompletableFuture<WaiterResponse<GetChannelResponse>> waitUntilChannelCreated(GetChannelRequest getChannelRequest) {
        return this.channelCreatedWaiter.runAsync(() -> this.client.getChannel(this.applyWaitersUserAgent(getChannelRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetChannelResponse>> waitUntilChannelCreated(GetChannelRequest getChannelRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.channelCreatedWaiter.runAsync(() -> this.client.getChannel(this.applyWaitersUserAgent(getChannelRequest)), DefaultRepostspaceAsyncWaiter.channelCreatedWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetChannelResponse>> waitUntilChannelDeleted(GetChannelRequest getChannelRequest) {
        return this.channelDeletedWaiter.runAsync(() -> this.client.getChannel(this.applyWaitersUserAgent(getChannelRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetChannelResponse>> waitUntilChannelDeleted(GetChannelRequest getChannelRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.channelDeletedWaiter.runAsync(() -> this.client.getChannel(this.applyWaitersUserAgent(getChannelRequest)), DefaultRepostspaceAsyncWaiter.channelDeletedWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetSpaceResponse>> waitUntilSpaceCreated(GetSpaceRequest getSpaceRequest) {
        return this.spaceCreatedWaiter.runAsync(() -> this.client.getSpace(this.applyWaitersUserAgent(getSpaceRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetSpaceResponse>> waitUntilSpaceCreated(GetSpaceRequest getSpaceRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.spaceCreatedWaiter.runAsync(() -> this.client.getSpace(this.applyWaitersUserAgent(getSpaceRequest)), DefaultRepostspaceAsyncWaiter.spaceCreatedWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetSpaceResponse>> waitUntilSpaceDeleted(GetSpaceRequest getSpaceRequest) {
        return this.spaceDeletedWaiter.runAsync(() -> this.client.getSpace(this.applyWaitersUserAgent(getSpaceRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetSpaceResponse>> waitUntilSpaceDeleted(GetSpaceRequest getSpaceRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.spaceDeletedWaiter.runAsync(() -> this.client.getSpace(this.applyWaitersUserAgent(getSpaceRequest)), DefaultRepostspaceAsyncWaiter.spaceDeletedWaiterConfig(overrideConfig));
    }

    private static List<WaiterAcceptor<? super GetChannelResponse>> channelCreatedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetChannelResponse>> result = new ArrayList<WaiterAcceptor<? super GetChannelResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("channelStatus").value(), "CREATED");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("channelStatus").value(), "CREATE_FAILED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (channelStatus=CREATE_FAILED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("channelStatus").value(), "CREATING");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetChannelResponse>> channelDeletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetChannelResponse>> result = new ArrayList<WaiterAcceptor<? super GetChannelResponse>>();
        result.add(WaiterAcceptor.successOnExceptionAcceptor(error -> Objects.equals(DefaultRepostspaceAsyncWaiter.errorCode(error), "ResourceNotFoundException")));
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("channelStatus").value(), "DELETED");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("channelStatus").value(), "DELETE_FAILED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (channelStatus=DELETE_FAILED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("channelStatus").value(), "DELETING");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetSpaceResponse>> spaceCreatedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetSpaceResponse>> result = new ArrayList<WaiterAcceptor<? super GetSpaceResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "CREATED");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "CREATE_FAILED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (status=CREATE_FAILED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "CREATING");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetSpaceResponse>> spaceDeletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetSpaceResponse>> result = new ArrayList<WaiterAcceptor<? super GetSpaceResponse>>();
        result.add(WaiterAcceptor.successOnExceptionAcceptor(error -> Objects.equals(DefaultRepostspaceAsyncWaiter.errorCode(error), "ResourceNotFoundException")));
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "DELETED");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "DELETE_FAILED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (status=DELETE_FAILED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "DELETING");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static WaiterOverrideConfiguration channelCreatedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(2L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration channelDeletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(2L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration spaceCreatedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(24);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(300L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration spaceDeletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(24);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(300L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    public void close() {
        this.managedResources.close();
    }

    public static RepostspaceAsyncWaiter.Builder builder() {
        return new DefaultBuilder();
    }

    private <T extends RepostspaceRequest> T applyWaitersUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder().name("sdk-metrics").version("B").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((RepostspaceRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    public static final class DefaultBuilder
    implements RepostspaceAsyncWaiter.Builder {
        private RepostspaceAsyncClient client;
        private WaiterOverrideConfiguration overrideConfiguration;
        private ScheduledExecutorService executorService;

        private DefaultBuilder() {
        }

        @Override
        public RepostspaceAsyncWaiter.Builder scheduledExecutorService(ScheduledExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        @Override
        public RepostspaceAsyncWaiter.Builder overrideConfiguration(WaiterOverrideConfiguration overrideConfiguration) {
            this.overrideConfiguration = overrideConfiguration;
            return this;
        }

        @Override
        public RepostspaceAsyncWaiter.Builder client(RepostspaceAsyncClient client) {
            this.client = client;
            return this;
        }

        @Override
        public RepostspaceAsyncWaiter build() {
            return new DefaultRepostspaceAsyncWaiter(this);
        }
    }
}

