/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.repostspace.endpoints.internal;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsExecutionAttribute;
import software.amazon.awssdk.core.ClientEndpointProvider;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.SdkInternalExecutionAttribute;
import software.amazon.awssdk.core.useragent.BusinessMetricFeatureId;
import software.amazon.awssdk.endpoints.Endpoint;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.utils.FunctionalUtils;
import software.amazon.awssdk.utils.HostnameValidator;
import software.amazon.awssdk.utils.Logger;
import software.amazon.awssdk.utils.StringUtils;
import software.amazon.awssdk.utils.http.SdkHttpUtils;

@SdkInternalApi
public final class AwsEndpointProviderUtils {
    private static final Logger LOG = Logger.loggerFor(AwsEndpointProviderUtils.class);

    private AwsEndpointProviderUtils() {
    }

    public static Region regionBuiltIn(ExecutionAttributes executionAttributes) {
        return (Region)executionAttributes.getAttribute(AwsExecutionAttribute.AWS_REGION);
    }

    public static Boolean dualStackEnabledBuiltIn(ExecutionAttributes executionAttributes) {
        return (Boolean)executionAttributes.getAttribute(AwsExecutionAttribute.DUALSTACK_ENDPOINT_ENABLED);
    }

    public static Boolean fipsEnabledBuiltIn(ExecutionAttributes executionAttributes) {
        return (Boolean)executionAttributes.getAttribute(AwsExecutionAttribute.FIPS_ENDPOINT_ENABLED);
    }

    public static String endpointBuiltIn(ExecutionAttributes executionAttributes) {
        if (AwsEndpointProviderUtils.endpointIsOverridden(executionAttributes)) {
            executionAttributes.getOptionalAttribute(SdkInternalExecutionAttribute.BUSINESS_METRICS).ifPresent(metric -> metric.addMetric(BusinessMetricFeatureId.ENDPOINT_OVERRIDE.value()));
            return (String)FunctionalUtils.invokeSafely(() -> {
                URI endpointOverride = ((ClientEndpointProvider)executionAttributes.getAttribute(SdkInternalExecutionAttribute.CLIENT_ENDPOINT_PROVIDER)).clientEndpoint();
                return new URI(endpointOverride.getScheme(), null, endpointOverride.getHost(), endpointOverride.getPort(), endpointOverride.getPath(), null, endpointOverride.getFragment()).toString();
            });
        }
        return null;
    }

    public static boolean endpointIsOverridden(ExecutionAttributes attrs) {
        return ((ClientEndpointProvider)attrs.getAttribute(SdkInternalExecutionAttribute.CLIENT_ENDPOINT_PROVIDER)).isEndpointOverridden();
    }

    public static boolean endpointIsDiscovered(ExecutionAttributes attrs) {
        return attrs.getOptionalAttribute(SdkInternalExecutionAttribute.IS_DISCOVERED_ENDPOINT).orElse(false);
    }

    public static boolean disableHostPrefixInjection(ExecutionAttributes attrs) {
        return attrs.getOptionalAttribute(SdkInternalExecutionAttribute.DISABLE_HOST_PREFIX_INJECTION).orElse(false);
    }

    public static Endpoint addHostPrefix(Endpoint endpoint, String prefix) {
        if (StringUtils.isBlank((CharSequence)prefix)) {
            return endpoint;
        }
        AwsEndpointProviderUtils.validatePrefixIsHostNameCompliant(prefix);
        URI originalUrl = endpoint.url();
        String newHost = prefix + endpoint.url().getHost();
        URI newUrl = (URI)FunctionalUtils.invokeSafely(() -> new URI(originalUrl.getScheme(), null, newHost, originalUrl.getPort(), originalUrl.getPath(), originalUrl.getQuery(), originalUrl.getFragment()));
        return endpoint.toBuilder().url(newUrl).build();
    }

    public static SdkHttpRequest setUri(SdkHttpRequest request, URI clientEndpoint, URI resolvedUri) {
        String clientEndpointPath = clientEndpoint.getRawPath();
        String requestPath = request.encodedPath();
        String resolvedUriPath = resolvedUri.getRawPath();
        String finalPath = requestPath;
        if (!resolvedUriPath.equals(clientEndpointPath)) {
            finalPath = AwsEndpointProviderUtils.combinePath(clientEndpointPath, requestPath, resolvedUriPath);
        }
        return (SdkHttpRequest)((SdkHttpRequest.Builder)request.toBuilder()).protocol(resolvedUri.getScheme()).host(resolvedUri.getHost()).port(Integer.valueOf(resolvedUri.getPort())).encodedPath(finalPath).build();
    }

    private static String combinePath(String clientEndpointPath, String requestPath, String resolvedUriPath) {
        String requestPathWithClientPathRemoved = StringUtils.replaceOnce((String)requestPath, (String)clientEndpointPath, (String)"");
        String finalPath = SdkHttpUtils.appendUri((String)resolvedUriPath, (String)requestPathWithClientPathRemoved);
        return finalPath;
    }

    private static void validatePrefixIsHostNameCompliant(String prefix) {
        String[] components;
        for (String component : components = AwsEndpointProviderUtils.splitHostLabelOnDots(prefix)) {
            HostnameValidator.validateHostnameCompliant((String)component, (String)component, (String)"request");
        }
    }

    private static String[] splitHostLabelOnDots(String label) {
        return label.split("\\.");
    }
}

