/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.repostspace.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.repostspace.model.AccessorIdListCopier;
import software.amazon.awssdk.services.repostspace.model.RepostspaceRequest;
import software.amazon.awssdk.services.repostspace.model.Role;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchAddRoleRequest
extends RepostspaceRequest
implements ToCopyableBuilder<Builder, BatchAddRoleRequest> {
    private static final SdkField<List<String>> ACCESSOR_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("accessorIds").getter(BatchAddRoleRequest.getter(BatchAddRoleRequest::accessorIds)).setter(BatchAddRoleRequest.setter(Builder::accessorIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessorIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("role").getter(BatchAddRoleRequest.getter(BatchAddRoleRequest::roleAsString)).setter(BatchAddRoleRequest.setter(Builder::role)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("role").build()}).build();
    private static final SdkField<String> SPACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("spaceId").getter(BatchAddRoleRequest.getter(BatchAddRoleRequest::spaceId)).setter(BatchAddRoleRequest.setter(Builder::spaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("spaceId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESSOR_IDS_FIELD, ROLE_FIELD, SPACE_ID_FIELD));
    private final List<String> accessorIds;
    private final String role;
    private final String spaceId;

    private BatchAddRoleRequest(BuilderImpl builder) {
        super(builder);
        this.accessorIds = builder.accessorIds;
        this.role = builder.role;
        this.spaceId = builder.spaceId;
    }

    public final boolean hasAccessorIds() {
        return this.accessorIds != null && !(this.accessorIds instanceof SdkAutoConstructList);
    }

    public final List<String> accessorIds() {
        return this.accessorIds;
    }

    public final Role role() {
        return Role.fromValue(this.role);
    }

    public final String roleAsString() {
        return this.role;
    }

    public final String spaceId() {
        return this.spaceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAccessorIds() ? this.accessorIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.roleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.spaceId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchAddRoleRequest)) {
            return false;
        }
        BatchAddRoleRequest other = (BatchAddRoleRequest)((Object)obj);
        return this.hasAccessorIds() == other.hasAccessorIds() && Objects.equals(this.accessorIds(), other.accessorIds()) && Objects.equals(this.roleAsString(), other.roleAsString()) && Objects.equals(this.spaceId(), other.spaceId());
    }

    public final String toString() {
        return ToString.builder((String)"BatchAddRoleRequest").add("AccessorIds", this.hasAccessorIds() ? this.accessorIds() : null).add("Role", (Object)this.roleAsString()).add("SpaceId", (Object)this.spaceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accessorIds": {
                return Optional.ofNullable(clazz.cast(this.accessorIds()));
            }
            case "role": {
                return Optional.ofNullable(clazz.cast(this.roleAsString()));
            }
            case "spaceId": {
                return Optional.ofNullable(clazz.cast(this.spaceId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchAddRoleRequest, T> g) {
        return obj -> g.apply((BatchAddRoleRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RepostspaceRequest.BuilderImpl
    implements Builder {
        private List<String> accessorIds = DefaultSdkAutoConstructList.getInstance();
        private String role;
        private String spaceId;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchAddRoleRequest model) {
            super(model);
            this.accessorIds(model.accessorIds);
            this.role(model.role);
            this.spaceId(model.spaceId);
        }

        public final Collection<String> getAccessorIds() {
            if (this.accessorIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.accessorIds;
        }

        public final void setAccessorIds(Collection<String> accessorIds) {
            this.accessorIds = AccessorIdListCopier.copy(accessorIds);
        }

        @Override
        public final Builder accessorIds(Collection<String> accessorIds) {
            this.accessorIds = AccessorIdListCopier.copy(accessorIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessorIds(String ... accessorIds) {
            this.accessorIds(Arrays.asList(accessorIds));
            return this;
        }

        public final String getRole() {
            return this.role;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        @Override
        public final Builder role(Role role) {
            this.role(role == null ? null : role.toString());
            return this;
        }

        public final String getSpaceId() {
            return this.spaceId;
        }

        public final void setSpaceId(String spaceId) {
            this.spaceId = spaceId;
        }

        @Override
        public final Builder spaceId(String spaceId) {
            this.spaceId = spaceId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchAddRoleRequest build() {
            return new BatchAddRoleRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RepostspaceRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchAddRoleRequest> {
        public Builder accessorIds(Collection<String> var1);

        public Builder accessorIds(String ... var1);

        public Builder role(String var1);

        public Builder role(Role var1);

        public Builder spaceId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

