/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.repostspace.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.repostspace.model.AccessorIdListCopier;
import software.amazon.awssdk.services.repostspace.model.RepostspaceRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SendInvitesRequest
extends RepostspaceRequest
implements ToCopyableBuilder<Builder, SendInvitesRequest> {
    private static final SdkField<List<String>> ACCESSOR_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("accessorIds").getter(SendInvitesRequest.getter(SendInvitesRequest::accessorIds)).setter(SendInvitesRequest.setter(Builder::accessorIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessorIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> BODY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("body").getter(SendInvitesRequest.getter(SendInvitesRequest::body)).setter(SendInvitesRequest.setter(Builder::body)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("body").build()}).build();
    private static final SdkField<String> SPACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("spaceId").getter(SendInvitesRequest.getter(SendInvitesRequest::spaceId)).setter(SendInvitesRequest.setter(Builder::spaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("spaceId").build()}).build();
    private static final SdkField<String> TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("title").getter(SendInvitesRequest.getter(SendInvitesRequest::title)).setter(SendInvitesRequest.setter(Builder::title)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("title").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESSOR_IDS_FIELD, BODY_FIELD, SPACE_ID_FIELD, TITLE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("accessorIds", ACCESSOR_IDS_FIELD);
            this.put("body", BODY_FIELD);
            this.put("spaceId", SPACE_ID_FIELD);
            this.put("title", TITLE_FIELD);
        }
    });
    private final List<String> accessorIds;
    private final String body;
    private final String spaceId;
    private final String title;

    private SendInvitesRequest(BuilderImpl builder) {
        super(builder);
        this.accessorIds = builder.accessorIds;
        this.body = builder.body;
        this.spaceId = builder.spaceId;
        this.title = builder.title;
    }

    public final boolean hasAccessorIds() {
        return this.accessorIds != null && !(this.accessorIds instanceof SdkAutoConstructList);
    }

    public final List<String> accessorIds() {
        return this.accessorIds;
    }

    public final String body() {
        return this.body;
    }

    public final String spaceId() {
        return this.spaceId;
    }

    public final String title() {
        return this.title;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAccessorIds() ? this.accessorIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.body());
        hashCode = 31 * hashCode + Objects.hashCode(this.spaceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.title());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendInvitesRequest)) {
            return false;
        }
        SendInvitesRequest other = (SendInvitesRequest)((Object)obj);
        return this.hasAccessorIds() == other.hasAccessorIds() && Objects.equals(this.accessorIds(), other.accessorIds()) && Objects.equals(this.body(), other.body()) && Objects.equals(this.spaceId(), other.spaceId()) && Objects.equals(this.title(), other.title());
    }

    public final String toString() {
        return ToString.builder((String)"SendInvitesRequest").add("AccessorIds", this.hasAccessorIds() ? this.accessorIds() : null).add("Body", (Object)(this.body() == null ? null : "*** Sensitive Data Redacted ***")).add("SpaceId", (Object)this.spaceId()).add("Title", (Object)(this.title() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accessorIds": {
                return Optional.ofNullable(clazz.cast(this.accessorIds()));
            }
            case "body": {
                return Optional.ofNullable(clazz.cast(this.body()));
            }
            case "spaceId": {
                return Optional.ofNullable(clazz.cast(this.spaceId()));
            }
            case "title": {
                return Optional.ofNullable(clazz.cast(this.title()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SendInvitesRequest, T> g) {
        return obj -> g.apply((SendInvitesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RepostspaceRequest.BuilderImpl
    implements Builder {
        private List<String> accessorIds = DefaultSdkAutoConstructList.getInstance();
        private String body;
        private String spaceId;
        private String title;

        private BuilderImpl() {
        }

        private BuilderImpl(SendInvitesRequest model) {
            super(model);
            this.accessorIds(model.accessorIds);
            this.body(model.body);
            this.spaceId(model.spaceId);
            this.title(model.title);
        }

        public final Collection<String> getAccessorIds() {
            if (this.accessorIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.accessorIds;
        }

        public final void setAccessorIds(Collection<String> accessorIds) {
            this.accessorIds = AccessorIdListCopier.copy(accessorIds);
        }

        @Override
        public final Builder accessorIds(Collection<String> accessorIds) {
            this.accessorIds = AccessorIdListCopier.copy(accessorIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessorIds(String ... accessorIds) {
            this.accessorIds(Arrays.asList(accessorIds));
            return this;
        }

        public final String getBody() {
            return this.body;
        }

        public final void setBody(String body) {
            this.body = body;
        }

        @Override
        public final Builder body(String body) {
            this.body = body;
            return this;
        }

        public final String getSpaceId() {
            return this.spaceId;
        }

        public final void setSpaceId(String spaceId) {
            this.spaceId = spaceId;
        }

        @Override
        public final Builder spaceId(String spaceId) {
            this.spaceId = spaceId;
            return this;
        }

        public final String getTitle() {
            return this.title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SendInvitesRequest build() {
            return new SendInvitesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends RepostspaceRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SendInvitesRequest> {
        public Builder accessorIds(Collection<String> var1);

        public Builder accessorIds(String ... var1);

        public Builder body(String var1);

        public Builder spaceId(String var1);

        public Builder title(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

