/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.release;

import java.util.stream.Stream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import software.amazon.awssdk.utils.Logger;

public abstract class Cli {
    private final Logger log = Logger.loggerFor(Cli.class);
    private final Option[] optionsToAdd;

    public Cli(Option ... optionsToAdd) {
        this.optionsToAdd = optionsToAdd;
    }

    public final void run(String[] args) {
        Options options = new Options();
        Stream.of(this.optionsToAdd).forEach(arg_0 -> ((Options)options).addOption(arg_0));
        DefaultParser parser = new DefaultParser();
        HelpFormatter help = new HelpFormatter();
        try {
            CommandLine commandLine = parser.parse(options, args);
            this.run(commandLine);
        }
        catch (ParseException e) {
            this.log.error(() -> "Invalid input: " + e.getMessage());
            help.printHelp(this.getClass().getSimpleName(), options);
            throw new Error();
        }
        catch (Exception e) {
            this.log.error(() -> "Script execution failed.", (Throwable)e);
            throw new Error();
        }
    }

    protected static Option requiredOption(String longCommand, String description) {
        Option option = Cli.optionalOption(longCommand, description);
        option.setRequired(true);
        return option;
    }

    protected static Option optionalOption(String longCommand, String description) {
        return new Option(null, longCommand, true, description);
    }

    protected static Option optionalMultiValueOption(String longCommand, String description) {
        return Option.builder().longOpt(longCommand).desc(description).hasArgs().build();
    }

    protected abstract void run(CommandLine var1) throws Exception;
}

