/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.release;

import java.nio.file.Path;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class PomTransformer {
    public final void transform(Path file) throws Exception {
        DocumentBuilderFactory docFactory = this.newSecureDocumentBuilderFactory();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        Document doc = docBuilder.parse(file.toFile());
        doc.normalize();
        XPath xPath = XPathFactory.newInstance().newXPath();
        NodeList nodeList = (NodeList)xPath.evaluate("//text()[normalize-space()='']", doc, XPathConstants.NODESET);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            node.getParentNode().removeChild(node);
        }
        this.updateDocument(doc);
        TransformerFactory transformerFactory = this.newSecureTransformerFactory();
        transformerFactory.setAttribute("indent-number", 4);
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("encoding", "UTF-8");
        DOMSource source = new DOMSource(doc);
        StreamResult result = new StreamResult(file.toFile());
        transformer.transform(source, result);
    }

    protected abstract void updateDocument(Document var1);

    protected final Node findChild(Node parent, String childName) {
        NodeList children = parent.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!childName.equals(child.getNodeName()) || child.getNodeType() != 1) continue;
            return child;
        }
        throw new IllegalArgumentException(parent + " has no child element named " + childName);
    }

    protected final void addChild(Node parent, Element childToAdd) {
        NodeList children = parent.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node existingChild = children.item(i);
            if (!existingChild.isEqualNode(childToAdd)) continue;
            return;
        }
        parent.appendChild(childToAdd);
    }

    protected final Element textElement(Document doc, String name, String value) {
        Element element = doc.createElement(name);
        element.setTextContent(value);
        return element;
    }

    protected final Element sdkDependencyElement(Document doc, String artifactId) {
        Element newDependency = doc.createElement("dependency");
        newDependency.appendChild(this.textElement(doc, "groupId", "software.amazon.awssdk"));
        newDependency.appendChild(this.textElement(doc, "artifactId", artifactId));
        newDependency.appendChild(this.textElement(doc, "version", "${awsjavasdk.version}"));
        return newDependency;
    }

    private DocumentBuilderFactory newSecureDocumentBuilderFactory() {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        docFactory.setXIncludeAware(false);
        docFactory.setExpandEntityReferences(false);
        this.trySetFeature(docFactory, "http://javax.xml.XMLConstants/feature/secure-processing", true);
        this.trySetFeature(docFactory, "http://apache.org/xml/features/disallow-doctype-decl", true);
        this.trySetFeature(docFactory, "http://xml.org/sax/features/external-general-entities", false);
        this.trySetFeature(docFactory, "http://xml.org/sax/features/external-parameter-entities", false);
        this.trySetAttribute(docFactory, "http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        this.trySetAttribute(docFactory, "http://javax.xml.XMLConstants/property/accessExternalSchema", "");
        return docFactory;
    }

    private TransformerFactory newSecureTransformerFactory() {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        this.trySetAttribute(transformerFactory, "http://javax.xml.XMLConstants/property/accessExternalDTD", (Object)"");
        this.trySetAttribute(transformerFactory, "http://javax.xml.XMLConstants/property/accessExternalStylesheet", (Object)"");
        return transformerFactory;
    }

    private void trySetFeature(DocumentBuilderFactory factory, String feature, boolean value) {
        try {
            factory.setFeature(feature, value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void trySetAttribute(DocumentBuilderFactory factory, String feature, String value) {
        try {
            factory.setAttribute(feature, value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void trySetAttribute(TransformerFactory factory, String feature, Object value) {
        try {
            factory.setAttribute(feature, value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

