/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.release;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import software.amazon.awssdk.release.PomTransformer;
import software.amazon.awssdk.utils.Logger;

public class NewServiceMain {
    private static final Logger log = Logger.loggerFor(NewServiceMain.class);

    private NewServiceMain() {
    }

    public static void main(String[] args) {
        Options options = new Options();
        options.addOption(NewServiceMain.requiredOption("service-module-name", "The name of the service module to be created."));
        options.addOption(NewServiceMain.requiredOption("service-id", "The service ID of the service module to be created."));
        options.addOption(NewServiceMain.requiredOption("service-protocol", "The protocol of the service module to be created."));
        options.addOption(NewServiceMain.requiredOption("maven-project-root", "The root directory for the maven project."));
        options.addOption(NewServiceMain.requiredOption("maven-project-version", "The maven version of the service module to be created."));
        DefaultParser parser = new DefaultParser();
        HelpFormatter help = new HelpFormatter();
        try {
            CommandLine commandLine = parser.parse(options, args);
            new NewServiceCreator(commandLine).run();
        }
        catch (ParseException e) {
            log.error(() -> "Invalid input: " + e.getMessage());
            help.printHelp("NewServiceMain", options);
            System.exit(1);
        }
        catch (Exception e) {
            log.error(() -> "Script execution failed.", (Throwable)e);
            System.exit(2);
        }
    }

    private static Option requiredOption(String longCommand, String description) {
        Option option = new Option(null, longCommand, true, description);
        option.setRequired(true);
        return option;
    }

    private static class NewServiceCreator {
        private final Path mavenProjectRoot;
        private final String mavenProjectVersion;
        private final String serviceModuleName;
        private final String serviceId;
        private final String serviceProtocol;

        private NewServiceCreator(CommandLine commandLine) {
            this.mavenProjectRoot = Paths.get(commandLine.getOptionValue("maven-project-root").trim(), new String[0]);
            this.mavenProjectVersion = commandLine.getOptionValue("maven-project-version").trim();
            this.serviceModuleName = commandLine.getOptionValue("service-module-name").trim();
            this.serviceId = commandLine.getOptionValue("service-id").trim();
            this.serviceProtocol = this.transformSpecialProtocols(commandLine.getOptionValue("service-protocol").trim());
        }

        private String transformSpecialProtocols(String protocol) {
            switch (protocol) {
                case "ec2": {
                    return "query";
                }
                case "rest-xml": {
                    return "xml";
                }
                case "rest-json": {
                    return "json";
                }
            }
            return protocol;
        }

        public void run() throws Exception {
            Path servicesRoot = this.mavenProjectRoot.resolve("services");
            Path templateModulePath = servicesRoot.resolve("new-service-template");
            Path newServiceModulePath = servicesRoot.resolve(this.serviceModuleName);
            this.createNewModuleFromTemplate(templateModulePath, newServiceModulePath);
            this.replaceTemplatePlaceholders(newServiceModulePath);
            Path servicesPomPath = this.mavenProjectRoot.resolve("services").resolve("pom.xml");
            Path aggregatePomPath = this.mavenProjectRoot.resolve("aws-sdk-java").resolve("pom.xml");
            Path bomPomPath = this.mavenProjectRoot.resolve("bom").resolve("pom.xml");
            new AddSubmoduleTransformer().transform(servicesPomPath);
            new AddDependencyTransformer().transform(aggregatePomPath);
            new AddDependencyManagementDependencyTransformer().transform(bomPomPath);
        }

        private void createNewModuleFromTemplate(Path templateModulePath, Path newServiceModule) throws IOException {
            FileUtils.copyDirectory((File)templateModulePath.toFile(), (File)newServiceModule.toFile());
        }

        private void replaceTemplatePlaceholders(Path newServiceModule) throws IOException {
            Files.walkFileTree(newServiceModule, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    this.replacePlaceholdersInFile(file);
                    return FileVisitResult.CONTINUE;
                }
            });
        }

        private void replacePlaceholdersInFile(Path file) throws IOException {
            String fileContents = new String(Files.readAllBytes(file), StandardCharsets.UTF_8);
            String newFileContents = this.replacePlaceholders(fileContents);
            Files.write(file, newFileContents.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }

        private String replacePlaceholders(String line) {
            String[] searchList = new String[]{"{{MVN_ARTIFACT_ID}}", "{{MVN_NAME}}", "{{MVN_VERSION}}", "{{PROTOCOL}}"};
            String[] replaceList = new String[]{this.serviceModuleName, this.serviceId, this.mavenProjectVersion, this.serviceProtocol};
            return StringUtils.replaceEach((String)line, (String[])searchList, (String[])replaceList);
        }

        private class AddDependencyManagementDependencyTransformer
        extends PomTransformer {
            private AddDependencyManagementDependencyTransformer() {
            }

            @Override
            protected void updateDocument(Document doc) {
                Node project = this.findChild(doc, "project");
                Node dependencyManagement = this.findChild(project, "dependencyManagement");
                Node dependencies = this.findChild(dependencyManagement, "dependencies");
                dependencies.appendChild(this.sdkDependencyElement(doc, NewServiceCreator.this.serviceModuleName));
            }
        }

        private class AddDependencyTransformer
        extends PomTransformer {
            private AddDependencyTransformer() {
            }

            @Override
            protected void updateDocument(Document doc) {
                Node project = this.findChild(doc, "project");
                Node dependencies = this.findChild(project, "dependencies");
                dependencies.appendChild(this.sdkDependencyElement(doc, NewServiceCreator.this.serviceModuleName));
            }
        }

        private class AddSubmoduleTransformer
        extends PomTransformer {
            private AddSubmoduleTransformer() {
            }

            @Override
            protected void updateDocument(Document doc) {
                Node project = this.findChild(doc, "project");
                Node modules = this.findChild(project, "modules");
                modules.appendChild(this.textElement(doc, "module", NewServiceCreator.this.serviceModuleName));
            }
        }
    }
}

