/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum EmotionName {
    HAPPY("HAPPY"),
    SAD("SAD"),
    ANGRY("ANGRY"),
    CONFUSED("CONFUSED"),
    DISGUSTED("DISGUSTED"),
    SURPRISED("SURPRISED"),
    CALM("CALM"),
    UNKNOWN("UNKNOWN"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private EmotionName(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static EmotionName fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(EmotionName.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<EmotionName> knownValues() {
        return Stream.of(EmotionName.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

