/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.rekognition.model.Face;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FaceMatch
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FaceMatch> {
    private static final SdkField<Float> SIMILARITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).getter(FaceMatch.getter(FaceMatch::similarity)).setter(FaceMatch.setter(Builder::similarity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Similarity").build()}).build();
    private static final SdkField<Face> FACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(FaceMatch.getter(FaceMatch::face)).setter(FaceMatch.setter(Builder::face)).constructor(Face::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Face").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SIMILARITY_FIELD, FACE_FIELD));
    private static final long serialVersionUID = 1L;
    private final Float similarity;
    private final Face face;

    private FaceMatch(BuilderImpl builder) {
        this.similarity = builder.similarity;
        this.face = builder.face;
    }

    public Float similarity() {
        return this.similarity;
    }

    public Face face() {
        return this.face;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.similarity());
        hashCode = 31 * hashCode + Objects.hashCode(this.face());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FaceMatch)) {
            return false;
        }
        FaceMatch other = (FaceMatch)obj;
        return Objects.equals(this.similarity(), other.similarity()) && Objects.equals(this.face(), other.face());
    }

    public String toString() {
        return ToString.builder((String)"FaceMatch").add("Similarity", (Object)this.similarity()).add("Face", (Object)this.face()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Similarity": {
                return Optional.ofNullable(clazz.cast(this.similarity()));
            }
            case "Face": {
                return Optional.ofNullable(clazz.cast(this.face()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FaceMatch, T> g) {
        return obj -> g.apply((FaceMatch)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Float similarity;
        private Face face;

        private BuilderImpl() {
        }

        private BuilderImpl(FaceMatch model) {
            this.similarity(model.similarity);
            this.face(model.face);
        }

        public final Float getSimilarity() {
            return this.similarity;
        }

        @Override
        public final Builder similarity(Float similarity) {
            this.similarity = similarity;
            return this;
        }

        public final void setSimilarity(Float similarity) {
            this.similarity = similarity;
        }

        public final Face.Builder getFace() {
            return this.face != null ? this.face.toBuilder() : null;
        }

        @Override
        public final Builder face(Face face) {
            this.face = face;
            return this;
        }

        public final void setFace(Face.BuilderImpl face) {
            this.face = face != null ? face.build() : null;
        }

        public FaceMatch build() {
            return new FaceMatch(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FaceMatch> {
        public Builder similarity(Float var1);

        public Builder face(Face var1);

        default public Builder face(Consumer<Face.Builder> face) {
            return this.face((Face)((Face.Builder)Face.builder().applyMutation(face)).build());
        }
    }
}

