/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DatasetStats
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DatasetStats> {
    private static final SdkField<Integer> LABELED_ENTRIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("LabeledEntries").getter(DatasetStats.getter(DatasetStats::labeledEntries)).setter(DatasetStats.setter(Builder::labeledEntries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabeledEntries").build()}).build();
    private static final SdkField<Integer> TOTAL_ENTRIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TotalEntries").getter(DatasetStats.getter(DatasetStats::totalEntries)).setter(DatasetStats.setter(Builder::totalEntries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalEntries").build()}).build();
    private static final SdkField<Integer> TOTAL_LABELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TotalLabels").getter(DatasetStats.getter(DatasetStats::totalLabels)).setter(DatasetStats.setter(Builder::totalLabels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalLabels").build()}).build();
    private static final SdkField<Integer> ERROR_ENTRIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ErrorEntries").getter(DatasetStats.getter(DatasetStats::errorEntries)).setter(DatasetStats.setter(Builder::errorEntries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorEntries").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LABELED_ENTRIES_FIELD, TOTAL_ENTRIES_FIELD, TOTAL_LABELS_FIELD, ERROR_ENTRIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DatasetStats.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer labeledEntries;
    private final Integer totalEntries;
    private final Integer totalLabels;
    private final Integer errorEntries;

    private DatasetStats(BuilderImpl builder) {
        this.labeledEntries = builder.labeledEntries;
        this.totalEntries = builder.totalEntries;
        this.totalLabels = builder.totalLabels;
        this.errorEntries = builder.errorEntries;
    }

    public final Integer labeledEntries() {
        return this.labeledEntries;
    }

    public final Integer totalEntries() {
        return this.totalEntries;
    }

    public final Integer totalLabels() {
        return this.totalLabels;
    }

    public final Integer errorEntries() {
        return this.errorEntries;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.labeledEntries());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalEntries());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalLabels());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorEntries());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatasetStats)) {
            return false;
        }
        DatasetStats other = (DatasetStats)obj;
        return Objects.equals(this.labeledEntries(), other.labeledEntries()) && Objects.equals(this.totalEntries(), other.totalEntries()) && Objects.equals(this.totalLabels(), other.totalLabels()) && Objects.equals(this.errorEntries(), other.errorEntries());
    }

    public final String toString() {
        return ToString.builder((String)"DatasetStats").add("LabeledEntries", (Object)this.labeledEntries()).add("TotalEntries", (Object)this.totalEntries()).add("TotalLabels", (Object)this.totalLabels()).add("ErrorEntries", (Object)this.errorEntries()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LabeledEntries": {
                return Optional.ofNullable(clazz.cast(this.labeledEntries()));
            }
            case "TotalEntries": {
                return Optional.ofNullable(clazz.cast(this.totalEntries()));
            }
            case "TotalLabels": {
                return Optional.ofNullable(clazz.cast(this.totalLabels()));
            }
            case "ErrorEntries": {
                return Optional.ofNullable(clazz.cast(this.errorEntries()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Integer>> map = new HashMap<String, SdkField<Integer>>();
        map.put("LabeledEntries", LABELED_ENTRIES_FIELD);
        map.put("TotalEntries", TOTAL_ENTRIES_FIELD);
        map.put("TotalLabels", TOTAL_LABELS_FIELD);
        map.put("ErrorEntries", ERROR_ENTRIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DatasetStats, T> g) {
        return obj -> g.apply((DatasetStats)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer labeledEntries;
        private Integer totalEntries;
        private Integer totalLabels;
        private Integer errorEntries;

        private BuilderImpl() {
        }

        private BuilderImpl(DatasetStats model) {
            this.labeledEntries(model.labeledEntries);
            this.totalEntries(model.totalEntries);
            this.totalLabels(model.totalLabels);
            this.errorEntries(model.errorEntries);
        }

        public final Integer getLabeledEntries() {
            return this.labeledEntries;
        }

        public final void setLabeledEntries(Integer labeledEntries) {
            this.labeledEntries = labeledEntries;
        }

        @Override
        public final Builder labeledEntries(Integer labeledEntries) {
            this.labeledEntries = labeledEntries;
            return this;
        }

        public final Integer getTotalEntries() {
            return this.totalEntries;
        }

        public final void setTotalEntries(Integer totalEntries) {
            this.totalEntries = totalEntries;
        }

        @Override
        public final Builder totalEntries(Integer totalEntries) {
            this.totalEntries = totalEntries;
            return this;
        }

        public final Integer getTotalLabels() {
            return this.totalLabels;
        }

        public final void setTotalLabels(Integer totalLabels) {
            this.totalLabels = totalLabels;
        }

        @Override
        public final Builder totalLabels(Integer totalLabels) {
            this.totalLabels = totalLabels;
            return this;
        }

        public final Integer getErrorEntries() {
            return this.errorEntries;
        }

        public final void setErrorEntries(Integer errorEntries) {
            this.errorEntries = errorEntries;
        }

        @Override
        public final Builder errorEntries(Integer errorEntries) {
            this.errorEntries = errorEntries;
            return this;
        }

        public DatasetStats build() {
            return new DatasetStats(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DatasetStats> {
        public Builder labeledEntries(Integer var1);

        public Builder totalEntries(Integer var1);

        public Builder totalLabels(Integer var1);

        public Builder errorEntries(Integer var1);
    }
}

