/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.rekognition.model.TechnicalCueType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TechnicalCueSegment
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TechnicalCueSegment> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(TechnicalCueSegment.getter(TechnicalCueSegment::typeAsString)).setter(TechnicalCueSegment.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<Float> CONFIDENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("Confidence").getter(TechnicalCueSegment.getter(TechnicalCueSegment::confidence)).setter(TechnicalCueSegment.setter(Builder::confidence)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Confidence").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, CONFIDENCE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TechnicalCueSegment.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String type;
    private final Float confidence;

    private TechnicalCueSegment(BuilderImpl builder) {
        this.type = builder.type;
        this.confidence = builder.confidence;
    }

    public final TechnicalCueType type() {
        return TechnicalCueType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final Float confidence() {
        return this.confidence;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.confidence());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TechnicalCueSegment)) {
            return false;
        }
        TechnicalCueSegment other = (TechnicalCueSegment)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.confidence(), other.confidence());
    }

    public final String toString() {
        return ToString.builder((String)"TechnicalCueSegment").add("Type", (Object)this.typeAsString()).add("Confidence", (Object)this.confidence()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "Confidence": {
                return Optional.ofNullable(clazz.cast(this.confidence()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Type", TYPE_FIELD);
        map.put("Confidence", CONFIDENCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TechnicalCueSegment, T> g) {
        return obj -> g.apply((TechnicalCueSegment)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private Float confidence;

        private BuilderImpl() {
        }

        private BuilderImpl(TechnicalCueSegment model) {
            this.type(model.type);
            this.confidence(model.confidence);
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(TechnicalCueType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Float getConfidence() {
            return this.confidence;
        }

        public final void setConfidence(Float confidence) {
            this.confidence = confidence;
        }

        @Override
        public final Builder confidence(Float confidence) {
            this.confidence = confidence;
            return this;
        }

        public TechnicalCueSegment build() {
            return new TechnicalCueSegment(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TechnicalCueSegment> {
        public Builder type(String var1);

        public Builder type(TechnicalCueType var1);

        public Builder confidence(Float var1);
    }
}

