/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rekognition.model.BoundingBox;
import software.amazon.awssdk.services.rekognition.model.DominantColor;
import software.amazon.awssdk.services.rekognition.model.DominantColorsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Instance
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Instance> {
    private static final SdkField<BoundingBox> BOUNDING_BOX_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BoundingBox").getter(Instance.getter(Instance::boundingBox)).setter(Instance.setter(Builder::boundingBox)).constructor(BoundingBox::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BoundingBox").build()}).build();
    private static final SdkField<Float> CONFIDENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("Confidence").getter(Instance.getter(Instance::confidence)).setter(Instance.setter(Builder::confidence)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Confidence").build()}).build();
    private static final SdkField<List<DominantColor>> DOMINANT_COLORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DominantColors").getter(Instance.getter(Instance::dominantColors)).setter(Instance.setter(Builder::dominantColors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DominantColors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DominantColor::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOUNDING_BOX_FIELD, CONFIDENCE_FIELD, DOMINANT_COLORS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Instance.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final BoundingBox boundingBox;
    private final Float confidence;
    private final List<DominantColor> dominantColors;

    private Instance(BuilderImpl builder) {
        this.boundingBox = builder.boundingBox;
        this.confidence = builder.confidence;
        this.dominantColors = builder.dominantColors;
    }

    public final BoundingBox boundingBox() {
        return this.boundingBox;
    }

    public final Float confidence() {
        return this.confidence;
    }

    public final boolean hasDominantColors() {
        return this.dominantColors != null && !(this.dominantColors instanceof SdkAutoConstructList);
    }

    public final List<DominantColor> dominantColors() {
        return this.dominantColors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.boundingBox());
        hashCode = 31 * hashCode + Objects.hashCode(this.confidence());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDominantColors() ? this.dominantColors() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Instance)) {
            return false;
        }
        Instance other = (Instance)obj;
        return Objects.equals(this.boundingBox(), other.boundingBox()) && Objects.equals(this.confidence(), other.confidence()) && this.hasDominantColors() == other.hasDominantColors() && Objects.equals(this.dominantColors(), other.dominantColors());
    }

    public final String toString() {
        return ToString.builder((String)"Instance").add("BoundingBox", (Object)this.boundingBox()).add("Confidence", (Object)this.confidence()).add("DominantColors", this.hasDominantColors() ? this.dominantColors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BoundingBox": {
                return Optional.ofNullable(clazz.cast(this.boundingBox()));
            }
            case "Confidence": {
                return Optional.ofNullable(clazz.cast(this.confidence()));
            }
            case "DominantColors": {
                return Optional.ofNullable(clazz.cast(this.dominantColors()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("BoundingBox", BOUNDING_BOX_FIELD);
        map.put("Confidence", CONFIDENCE_FIELD);
        map.put("DominantColors", DOMINANT_COLORS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Instance, T> g) {
        return obj -> g.apply((Instance)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private BoundingBox boundingBox;
        private Float confidence;
        private List<DominantColor> dominantColors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Instance model) {
            this.boundingBox(model.boundingBox);
            this.confidence(model.confidence);
            this.dominantColors(model.dominantColors);
        }

        public final BoundingBox.Builder getBoundingBox() {
            return this.boundingBox != null ? this.boundingBox.toBuilder() : null;
        }

        public final void setBoundingBox(BoundingBox.BuilderImpl boundingBox) {
            this.boundingBox = boundingBox != null ? boundingBox.build() : null;
        }

        @Override
        public final Builder boundingBox(BoundingBox boundingBox) {
            this.boundingBox = boundingBox;
            return this;
        }

        public final Float getConfidence() {
            return this.confidence;
        }

        public final void setConfidence(Float confidence) {
            this.confidence = confidence;
        }

        @Override
        public final Builder confidence(Float confidence) {
            this.confidence = confidence;
            return this;
        }

        public final List<DominantColor.Builder> getDominantColors() {
            List<DominantColor.Builder> result = DominantColorsCopier.copyToBuilder(this.dominantColors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDominantColors(Collection<DominantColor.BuilderImpl> dominantColors) {
            this.dominantColors = DominantColorsCopier.copyFromBuilder(dominantColors);
        }

        @Override
        public final Builder dominantColors(Collection<DominantColor> dominantColors) {
            this.dominantColors = DominantColorsCopier.copy(dominantColors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dominantColors(DominantColor ... dominantColors) {
            this.dominantColors(Arrays.asList(dominantColors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dominantColors(Consumer<DominantColor.Builder> ... dominantColors) {
            this.dominantColors(Stream.of(dominantColors).map(c -> (DominantColor)((DominantColor.Builder)DominantColor.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public Instance build() {
            return new Instance(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Instance> {
        public Builder boundingBox(BoundingBox var1);

        default public Builder boundingBox(Consumer<BoundingBox.Builder> boundingBox) {
            return this.boundingBox((BoundingBox)((BoundingBox.Builder)BoundingBox.builder().applyMutation(boundingBox)).build());
        }

        public Builder confidence(Float var1);

        public Builder dominantColors(Collection<DominantColor> var1);

        public Builder dominantColors(DominantColor ... var1);

        public Builder dominantColors(Consumer<DominantColor.Builder> ... var1);
    }
}

