/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rekognition.model.MediaAnalysisJobDescription;
import software.amazon.awssdk.services.rekognition.model.MediaAnalysisJobDescriptionsCopier;
import software.amazon.awssdk.services.rekognition.model.RekognitionResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListMediaAnalysisJobsResponse
extends RekognitionResponse
implements ToCopyableBuilder<Builder, ListMediaAnalysisJobsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListMediaAnalysisJobsResponse.getter(ListMediaAnalysisJobsResponse::nextToken)).setter(ListMediaAnalysisJobsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<MediaAnalysisJobDescription>> MEDIA_ANALYSIS_JOBS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MediaAnalysisJobs").getter(ListMediaAnalysisJobsResponse.getter(ListMediaAnalysisJobsResponse::mediaAnalysisJobs)).setter(ListMediaAnalysisJobsResponse.setter(Builder::mediaAnalysisJobs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediaAnalysisJobs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MediaAnalysisJobDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, MEDIA_ANALYSIS_JOBS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListMediaAnalysisJobsResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<MediaAnalysisJobDescription> mediaAnalysisJobs;

    private ListMediaAnalysisJobsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.mediaAnalysisJobs = builder.mediaAnalysisJobs;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasMediaAnalysisJobs() {
        return this.mediaAnalysisJobs != null && !(this.mediaAnalysisJobs instanceof SdkAutoConstructList);
    }

    public final List<MediaAnalysisJobDescription> mediaAnalysisJobs() {
        return this.mediaAnalysisJobs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMediaAnalysisJobs() ? this.mediaAnalysisJobs() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMediaAnalysisJobsResponse)) {
            return false;
        }
        ListMediaAnalysisJobsResponse other = (ListMediaAnalysisJobsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasMediaAnalysisJobs() == other.hasMediaAnalysisJobs() && Objects.equals(this.mediaAnalysisJobs(), other.mediaAnalysisJobs());
    }

    public final String toString() {
        return ToString.builder((String)"ListMediaAnalysisJobsResponse").add("NextToken", (Object)this.nextToken()).add("MediaAnalysisJobs", this.hasMediaAnalysisJobs() ? this.mediaAnalysisJobs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MediaAnalysisJobs": {
                return Optional.ofNullable(clazz.cast(this.mediaAnalysisJobs()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("MediaAnalysisJobs", MEDIA_ANALYSIS_JOBS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListMediaAnalysisJobsResponse, T> g) {
        return obj -> g.apply((ListMediaAnalysisJobsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RekognitionResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<MediaAnalysisJobDescription> mediaAnalysisJobs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListMediaAnalysisJobsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.mediaAnalysisJobs(model.mediaAnalysisJobs);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<MediaAnalysisJobDescription.Builder> getMediaAnalysisJobs() {
            List<MediaAnalysisJobDescription.Builder> result = MediaAnalysisJobDescriptionsCopier.copyToBuilder(this.mediaAnalysisJobs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMediaAnalysisJobs(Collection<MediaAnalysisJobDescription.BuilderImpl> mediaAnalysisJobs) {
            this.mediaAnalysisJobs = MediaAnalysisJobDescriptionsCopier.copyFromBuilder(mediaAnalysisJobs);
        }

        @Override
        public final Builder mediaAnalysisJobs(Collection<MediaAnalysisJobDescription> mediaAnalysisJobs) {
            this.mediaAnalysisJobs = MediaAnalysisJobDescriptionsCopier.copy(mediaAnalysisJobs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mediaAnalysisJobs(MediaAnalysisJobDescription ... mediaAnalysisJobs) {
            this.mediaAnalysisJobs(Arrays.asList(mediaAnalysisJobs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mediaAnalysisJobs(Consumer<MediaAnalysisJobDescription.Builder> ... mediaAnalysisJobs) {
            this.mediaAnalysisJobs(Stream.of(mediaAnalysisJobs).map(c -> (MediaAnalysisJobDescription)((MediaAnalysisJobDescription.Builder)MediaAnalysisJobDescription.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListMediaAnalysisJobsResponse build() {
            return new ListMediaAnalysisJobsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends RekognitionResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListMediaAnalysisJobsResponse> {
        public Builder nextToken(String var1);

        public Builder mediaAnalysisJobs(Collection<MediaAnalysisJobDescription> var1);

        public Builder mediaAnalysisJobs(MediaAnalysisJobDescription ... var1);

        public Builder mediaAnalysisJobs(Consumer<MediaAnalysisJobDescription.Builder> ... var1);
    }
}

