/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rekognition.model.LabelDetectionFeatureListCopier;
import software.amazon.awssdk.services.rekognition.model.LabelDetectionFeatureName;
import software.amazon.awssdk.services.rekognition.model.LabelDetectionSettings;
import software.amazon.awssdk.services.rekognition.model.NotificationChannel;
import software.amazon.awssdk.services.rekognition.model.RekognitionRequest;
import software.amazon.awssdk.services.rekognition.model.Video;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartLabelDetectionRequest
extends RekognitionRequest
implements ToCopyableBuilder<Builder, StartLabelDetectionRequest> {
    private static final SdkField<Video> VIDEO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Video").getter(StartLabelDetectionRequest.getter(StartLabelDetectionRequest::video)).setter(StartLabelDetectionRequest.setter(Builder::video)).constructor(Video::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Video").build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientRequestToken").getter(StartLabelDetectionRequest.getter(StartLabelDetectionRequest::clientRequestToken)).setter(StartLabelDetectionRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build()}).build();
    private static final SdkField<Float> MIN_CONFIDENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("MinConfidence").getter(StartLabelDetectionRequest.getter(StartLabelDetectionRequest::minConfidence)).setter(StartLabelDetectionRequest.setter(Builder::minConfidence)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinConfidence").build()}).build();
    private static final SdkField<NotificationChannel> NOTIFICATION_CHANNEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NotificationChannel").getter(StartLabelDetectionRequest.getter(StartLabelDetectionRequest::notificationChannel)).setter(StartLabelDetectionRequest.setter(Builder::notificationChannel)).constructor(NotificationChannel::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationChannel").build()}).build();
    private static final SdkField<String> JOB_TAG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobTag").getter(StartLabelDetectionRequest.getter(StartLabelDetectionRequest::jobTag)).setter(StartLabelDetectionRequest.setter(Builder::jobTag)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobTag").build()}).build();
    private static final SdkField<List<String>> FEATURES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Features").getter(StartLabelDetectionRequest.getter(StartLabelDetectionRequest::featuresAsStrings)).setter(StartLabelDetectionRequest.setter(Builder::featuresWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Features").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<LabelDetectionSettings> SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Settings").getter(StartLabelDetectionRequest.getter(StartLabelDetectionRequest::settings)).setter(StartLabelDetectionRequest.setter(Builder::settings)).constructor(LabelDetectionSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Settings").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VIDEO_FIELD, CLIENT_REQUEST_TOKEN_FIELD, MIN_CONFIDENCE_FIELD, NOTIFICATION_CHANNEL_FIELD, JOB_TAG_FIELD, FEATURES_FIELD, SETTINGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Video", VIDEO_FIELD);
            this.put("ClientRequestToken", CLIENT_REQUEST_TOKEN_FIELD);
            this.put("MinConfidence", MIN_CONFIDENCE_FIELD);
            this.put("NotificationChannel", NOTIFICATION_CHANNEL_FIELD);
            this.put("JobTag", JOB_TAG_FIELD);
            this.put("Features", FEATURES_FIELD);
            this.put("Settings", SETTINGS_FIELD);
        }
    });
    private final Video video;
    private final String clientRequestToken;
    private final Float minConfidence;
    private final NotificationChannel notificationChannel;
    private final String jobTag;
    private final List<String> features;
    private final LabelDetectionSettings settings;

    private StartLabelDetectionRequest(BuilderImpl builder) {
        super(builder);
        this.video = builder.video;
        this.clientRequestToken = builder.clientRequestToken;
        this.minConfidence = builder.minConfidence;
        this.notificationChannel = builder.notificationChannel;
        this.jobTag = builder.jobTag;
        this.features = builder.features;
        this.settings = builder.settings;
    }

    public final Video video() {
        return this.video;
    }

    public final String clientRequestToken() {
        return this.clientRequestToken;
    }

    public final Float minConfidence() {
        return this.minConfidence;
    }

    public final NotificationChannel notificationChannel() {
        return this.notificationChannel;
    }

    public final String jobTag() {
        return this.jobTag;
    }

    public final List<LabelDetectionFeatureName> features() {
        return LabelDetectionFeatureListCopier.copyStringToEnum(this.features);
    }

    public final boolean hasFeatures() {
        return this.features != null && !(this.features instanceof SdkAutoConstructList);
    }

    public final List<String> featuresAsStrings() {
        return this.features;
    }

    public final LabelDetectionSettings settings() {
        return this.settings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.video());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.minConfidence());
        hashCode = 31 * hashCode + Objects.hashCode(this.notificationChannel());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobTag());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFeatures() ? this.featuresAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.settings());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartLabelDetectionRequest)) {
            return false;
        }
        StartLabelDetectionRequest other = (StartLabelDetectionRequest)((Object)obj);
        return Objects.equals(this.video(), other.video()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken()) && Objects.equals(this.minConfidence(), other.minConfidence()) && Objects.equals(this.notificationChannel(), other.notificationChannel()) && Objects.equals(this.jobTag(), other.jobTag()) && this.hasFeatures() == other.hasFeatures() && Objects.equals(this.featuresAsStrings(), other.featuresAsStrings()) && Objects.equals(this.settings(), other.settings());
    }

    public final String toString() {
        return ToString.builder((String)"StartLabelDetectionRequest").add("Video", (Object)this.video()).add("ClientRequestToken", (Object)this.clientRequestToken()).add("MinConfidence", (Object)this.minConfidence()).add("NotificationChannel", (Object)this.notificationChannel()).add("JobTag", (Object)this.jobTag()).add("Features", this.hasFeatures() ? this.featuresAsStrings() : null).add("Settings", (Object)this.settings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Video": {
                return Optional.ofNullable(clazz.cast(this.video()));
            }
            case "ClientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
            case "MinConfidence": {
                return Optional.ofNullable(clazz.cast(this.minConfidence()));
            }
            case "NotificationChannel": {
                return Optional.ofNullable(clazz.cast(this.notificationChannel()));
            }
            case "JobTag": {
                return Optional.ofNullable(clazz.cast(this.jobTag()));
            }
            case "Features": {
                return Optional.ofNullable(clazz.cast(this.featuresAsStrings()));
            }
            case "Settings": {
                return Optional.ofNullable(clazz.cast(this.settings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<StartLabelDetectionRequest, T> g) {
        return obj -> g.apply((StartLabelDetectionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RekognitionRequest.BuilderImpl
    implements Builder {
        private Video video;
        private String clientRequestToken;
        private Float minConfidence;
        private NotificationChannel notificationChannel;
        private String jobTag;
        private List<String> features = DefaultSdkAutoConstructList.getInstance();
        private LabelDetectionSettings settings;

        private BuilderImpl() {
        }

        private BuilderImpl(StartLabelDetectionRequest model) {
            super(model);
            this.video(model.video);
            this.clientRequestToken(model.clientRequestToken);
            this.minConfidence(model.minConfidence);
            this.notificationChannel(model.notificationChannel);
            this.jobTag(model.jobTag);
            this.featuresWithStrings(model.features);
            this.settings(model.settings);
        }

        public final Video.Builder getVideo() {
            return this.video != null ? this.video.toBuilder() : null;
        }

        public final void setVideo(Video.BuilderImpl video) {
            this.video = video != null ? video.build() : null;
        }

        @Override
        public final Builder video(Video video) {
            this.video = video;
            return this;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final Float getMinConfidence() {
            return this.minConfidence;
        }

        public final void setMinConfidence(Float minConfidence) {
            this.minConfidence = minConfidence;
        }

        @Override
        public final Builder minConfidence(Float minConfidence) {
            this.minConfidence = minConfidence;
            return this;
        }

        public final NotificationChannel.Builder getNotificationChannel() {
            return this.notificationChannel != null ? this.notificationChannel.toBuilder() : null;
        }

        public final void setNotificationChannel(NotificationChannel.BuilderImpl notificationChannel) {
            this.notificationChannel = notificationChannel != null ? notificationChannel.build() : null;
        }

        @Override
        public final Builder notificationChannel(NotificationChannel notificationChannel) {
            this.notificationChannel = notificationChannel;
            return this;
        }

        public final String getJobTag() {
            return this.jobTag;
        }

        public final void setJobTag(String jobTag) {
            this.jobTag = jobTag;
        }

        @Override
        public final Builder jobTag(String jobTag) {
            this.jobTag = jobTag;
            return this;
        }

        public final Collection<String> getFeatures() {
            if (this.features instanceof SdkAutoConstructList) {
                return null;
            }
            return this.features;
        }

        public final void setFeatures(Collection<String> features) {
            this.features = LabelDetectionFeatureListCopier.copy(features);
        }

        @Override
        public final Builder featuresWithStrings(Collection<String> features) {
            this.features = LabelDetectionFeatureListCopier.copy(features);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder featuresWithStrings(String ... features) {
            this.featuresWithStrings(Arrays.asList(features));
            return this;
        }

        @Override
        public final Builder features(Collection<LabelDetectionFeatureName> features) {
            this.features = LabelDetectionFeatureListCopier.copyEnumToString(features);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder features(LabelDetectionFeatureName ... features) {
            this.features(Arrays.asList(features));
            return this;
        }

        public final LabelDetectionSettings.Builder getSettings() {
            return this.settings != null ? this.settings.toBuilder() : null;
        }

        public final void setSettings(LabelDetectionSettings.BuilderImpl settings) {
            this.settings = settings != null ? settings.build() : null;
        }

        @Override
        @Transient
        public final Builder settings(LabelDetectionSettings settings) {
            this.settings = settings;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartLabelDetectionRequest build() {
            return new StartLabelDetectionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends RekognitionRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartLabelDetectionRequest> {
        public Builder video(Video var1);

        default public Builder video(Consumer<Video.Builder> video) {
            return this.video((Video)((Video.Builder)Video.builder().applyMutation(video)).build());
        }

        public Builder clientRequestToken(String var1);

        public Builder minConfidence(Float var1);

        public Builder notificationChannel(NotificationChannel var1);

        default public Builder notificationChannel(Consumer<NotificationChannel.Builder> notificationChannel) {
            return this.notificationChannel((NotificationChannel)((NotificationChannel.Builder)NotificationChannel.builder().applyMutation(notificationChannel)).build());
        }

        public Builder jobTag(String var1);

        public Builder featuresWithStrings(Collection<String> var1);

        public Builder featuresWithStrings(String ... var1);

        public Builder features(Collection<LabelDetectionFeatureName> var1);

        public Builder features(LabelDetectionFeatureName ... var1);

        public Builder settings(LabelDetectionSettings var1);

        default public Builder settings(Consumer<LabelDetectionSettings.Builder> settings) {
            return this.settings((LabelDetectionSettings)((LabelDetectionSettings.Builder)LabelDetectionSettings.builder().applyMutation(settings)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

