/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rekognition.model.RegionOfInterest;
import software.amazon.awssdk.services.rekognition.model.RegionsOfInterestCopier;
import software.amazon.awssdk.services.rekognition.model.RekognitionRequest;
import software.amazon.awssdk.services.rekognition.model.StreamProcessorDataSharingPreference;
import software.amazon.awssdk.services.rekognition.model.StreamProcessorParameterToDelete;
import software.amazon.awssdk.services.rekognition.model.StreamProcessorParametersToDeleteCopier;
import software.amazon.awssdk.services.rekognition.model.StreamProcessorSettingsForUpdate;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateStreamProcessorRequest
extends RekognitionRequest
implements ToCopyableBuilder<Builder, UpdateStreamProcessorRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(UpdateStreamProcessorRequest.getter(UpdateStreamProcessorRequest::name)).setter(UpdateStreamProcessorRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<StreamProcessorSettingsForUpdate> SETTINGS_FOR_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SettingsForUpdate").getter(UpdateStreamProcessorRequest.getter(UpdateStreamProcessorRequest::settingsForUpdate)).setter(UpdateStreamProcessorRequest.setter(Builder::settingsForUpdate)).constructor(StreamProcessorSettingsForUpdate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SettingsForUpdate").build()}).build();
    private static final SdkField<List<RegionOfInterest>> REGIONS_OF_INTEREST_FOR_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RegionsOfInterestForUpdate").getter(UpdateStreamProcessorRequest.getter(UpdateStreamProcessorRequest::regionsOfInterestForUpdate)).setter(UpdateStreamProcessorRequest.setter(Builder::regionsOfInterestForUpdate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegionsOfInterestForUpdate").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RegionOfInterest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<StreamProcessorDataSharingPreference> DATA_SHARING_PREFERENCE_FOR_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataSharingPreferenceForUpdate").getter(UpdateStreamProcessorRequest.getter(UpdateStreamProcessorRequest::dataSharingPreferenceForUpdate)).setter(UpdateStreamProcessorRequest.setter(Builder::dataSharingPreferenceForUpdate)).constructor(StreamProcessorDataSharingPreference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSharingPreferenceForUpdate").build()}).build();
    private static final SdkField<List<String>> PARAMETERS_TO_DELETE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ParametersToDelete").getter(UpdateStreamProcessorRequest.getter(UpdateStreamProcessorRequest::parametersToDeleteAsStrings)).setter(UpdateStreamProcessorRequest.setter(Builder::parametersToDeleteWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParametersToDelete").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, SETTINGS_FOR_UPDATE_FIELD, REGIONS_OF_INTEREST_FOR_UPDATE_FIELD, DATA_SHARING_PREFERENCE_FOR_UPDATE_FIELD, PARAMETERS_TO_DELETE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Name", NAME_FIELD);
            this.put("SettingsForUpdate", SETTINGS_FOR_UPDATE_FIELD);
            this.put("RegionsOfInterestForUpdate", REGIONS_OF_INTEREST_FOR_UPDATE_FIELD);
            this.put("DataSharingPreferenceForUpdate", DATA_SHARING_PREFERENCE_FOR_UPDATE_FIELD);
            this.put("ParametersToDelete", PARAMETERS_TO_DELETE_FIELD);
        }
    });
    private final String name;
    private final StreamProcessorSettingsForUpdate settingsForUpdate;
    private final List<RegionOfInterest> regionsOfInterestForUpdate;
    private final StreamProcessorDataSharingPreference dataSharingPreferenceForUpdate;
    private final List<String> parametersToDelete;

    private UpdateStreamProcessorRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.settingsForUpdate = builder.settingsForUpdate;
        this.regionsOfInterestForUpdate = builder.regionsOfInterestForUpdate;
        this.dataSharingPreferenceForUpdate = builder.dataSharingPreferenceForUpdate;
        this.parametersToDelete = builder.parametersToDelete;
    }

    public final String name() {
        return this.name;
    }

    public final StreamProcessorSettingsForUpdate settingsForUpdate() {
        return this.settingsForUpdate;
    }

    public final boolean hasRegionsOfInterestForUpdate() {
        return this.regionsOfInterestForUpdate != null && !(this.regionsOfInterestForUpdate instanceof SdkAutoConstructList);
    }

    public final List<RegionOfInterest> regionsOfInterestForUpdate() {
        return this.regionsOfInterestForUpdate;
    }

    public final StreamProcessorDataSharingPreference dataSharingPreferenceForUpdate() {
        return this.dataSharingPreferenceForUpdate;
    }

    public final List<StreamProcessorParameterToDelete> parametersToDelete() {
        return StreamProcessorParametersToDeleteCopier.copyStringToEnum(this.parametersToDelete);
    }

    public final boolean hasParametersToDelete() {
        return this.parametersToDelete != null && !(this.parametersToDelete instanceof SdkAutoConstructList);
    }

    public final List<String> parametersToDeleteAsStrings() {
        return this.parametersToDelete;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.settingsForUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRegionsOfInterestForUpdate() ? this.regionsOfInterestForUpdate() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSharingPreferenceForUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParametersToDelete() ? this.parametersToDeleteAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateStreamProcessorRequest)) {
            return false;
        }
        UpdateStreamProcessorRequest other = (UpdateStreamProcessorRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.settingsForUpdate(), other.settingsForUpdate()) && this.hasRegionsOfInterestForUpdate() == other.hasRegionsOfInterestForUpdate() && Objects.equals(this.regionsOfInterestForUpdate(), other.regionsOfInterestForUpdate()) && Objects.equals(this.dataSharingPreferenceForUpdate(), other.dataSharingPreferenceForUpdate()) && this.hasParametersToDelete() == other.hasParametersToDelete() && Objects.equals(this.parametersToDeleteAsStrings(), other.parametersToDeleteAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateStreamProcessorRequest").add("Name", (Object)this.name()).add("SettingsForUpdate", (Object)this.settingsForUpdate()).add("RegionsOfInterestForUpdate", this.hasRegionsOfInterestForUpdate() ? this.regionsOfInterestForUpdate() : null).add("DataSharingPreferenceForUpdate", (Object)this.dataSharingPreferenceForUpdate()).add("ParametersToDelete", this.hasParametersToDelete() ? this.parametersToDeleteAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "SettingsForUpdate": {
                return Optional.ofNullable(clazz.cast(this.settingsForUpdate()));
            }
            case "RegionsOfInterestForUpdate": {
                return Optional.ofNullable(clazz.cast(this.regionsOfInterestForUpdate()));
            }
            case "DataSharingPreferenceForUpdate": {
                return Optional.ofNullable(clazz.cast(this.dataSharingPreferenceForUpdate()));
            }
            case "ParametersToDelete": {
                return Optional.ofNullable(clazz.cast(this.parametersToDeleteAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateStreamProcessorRequest, T> g) {
        return obj -> g.apply((UpdateStreamProcessorRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RekognitionRequest.BuilderImpl
    implements Builder {
        private String name;
        private StreamProcessorSettingsForUpdate settingsForUpdate;
        private List<RegionOfInterest> regionsOfInterestForUpdate = DefaultSdkAutoConstructList.getInstance();
        private StreamProcessorDataSharingPreference dataSharingPreferenceForUpdate;
        private List<String> parametersToDelete = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateStreamProcessorRequest model) {
            super(model);
            this.name(model.name);
            this.settingsForUpdate(model.settingsForUpdate);
            this.regionsOfInterestForUpdate(model.regionsOfInterestForUpdate);
            this.dataSharingPreferenceForUpdate(model.dataSharingPreferenceForUpdate);
            this.parametersToDeleteWithStrings(model.parametersToDelete);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final StreamProcessorSettingsForUpdate.Builder getSettingsForUpdate() {
            return this.settingsForUpdate != null ? this.settingsForUpdate.toBuilder() : null;
        }

        public final void setSettingsForUpdate(StreamProcessorSettingsForUpdate.BuilderImpl settingsForUpdate) {
            this.settingsForUpdate = settingsForUpdate != null ? settingsForUpdate.build() : null;
        }

        @Override
        @Transient
        public final Builder settingsForUpdate(StreamProcessorSettingsForUpdate settingsForUpdate) {
            this.settingsForUpdate = settingsForUpdate;
            return this;
        }

        public final List<RegionOfInterest.Builder> getRegionsOfInterestForUpdate() {
            List<RegionOfInterest.Builder> result = RegionsOfInterestCopier.copyToBuilder(this.regionsOfInterestForUpdate);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRegionsOfInterestForUpdate(Collection<RegionOfInterest.BuilderImpl> regionsOfInterestForUpdate) {
            this.regionsOfInterestForUpdate = RegionsOfInterestCopier.copyFromBuilder(regionsOfInterestForUpdate);
        }

        @Override
        public final Builder regionsOfInterestForUpdate(Collection<RegionOfInterest> regionsOfInterestForUpdate) {
            this.regionsOfInterestForUpdate = RegionsOfInterestCopier.copy(regionsOfInterestForUpdate);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regionsOfInterestForUpdate(RegionOfInterest ... regionsOfInterestForUpdate) {
            this.regionsOfInterestForUpdate(Arrays.asList(regionsOfInterestForUpdate));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regionsOfInterestForUpdate(Consumer<RegionOfInterest.Builder> ... regionsOfInterestForUpdate) {
            this.regionsOfInterestForUpdate(Stream.of(regionsOfInterestForUpdate).map(c -> (RegionOfInterest)((RegionOfInterest.Builder)RegionOfInterest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final StreamProcessorDataSharingPreference.Builder getDataSharingPreferenceForUpdate() {
            return this.dataSharingPreferenceForUpdate != null ? this.dataSharingPreferenceForUpdate.toBuilder() : null;
        }

        public final void setDataSharingPreferenceForUpdate(StreamProcessorDataSharingPreference.BuilderImpl dataSharingPreferenceForUpdate) {
            this.dataSharingPreferenceForUpdate = dataSharingPreferenceForUpdate != null ? dataSharingPreferenceForUpdate.build() : null;
        }

        @Override
        public final Builder dataSharingPreferenceForUpdate(StreamProcessorDataSharingPreference dataSharingPreferenceForUpdate) {
            this.dataSharingPreferenceForUpdate = dataSharingPreferenceForUpdate;
            return this;
        }

        public final Collection<String> getParametersToDelete() {
            if (this.parametersToDelete instanceof SdkAutoConstructList) {
                return null;
            }
            return this.parametersToDelete;
        }

        public final void setParametersToDelete(Collection<String> parametersToDelete) {
            this.parametersToDelete = StreamProcessorParametersToDeleteCopier.copy(parametersToDelete);
        }

        @Override
        public final Builder parametersToDeleteWithStrings(Collection<String> parametersToDelete) {
            this.parametersToDelete = StreamProcessorParametersToDeleteCopier.copy(parametersToDelete);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parametersToDeleteWithStrings(String ... parametersToDelete) {
            this.parametersToDeleteWithStrings(Arrays.asList(parametersToDelete));
            return this;
        }

        @Override
        public final Builder parametersToDelete(Collection<StreamProcessorParameterToDelete> parametersToDelete) {
            this.parametersToDelete = StreamProcessorParametersToDeleteCopier.copyEnumToString(parametersToDelete);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parametersToDelete(StreamProcessorParameterToDelete ... parametersToDelete) {
            this.parametersToDelete(Arrays.asList(parametersToDelete));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateStreamProcessorRequest build() {
            return new UpdateStreamProcessorRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends RekognitionRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateStreamProcessorRequest> {
        public Builder name(String var1);

        public Builder settingsForUpdate(StreamProcessorSettingsForUpdate var1);

        default public Builder settingsForUpdate(Consumer<StreamProcessorSettingsForUpdate.Builder> settingsForUpdate) {
            return this.settingsForUpdate((StreamProcessorSettingsForUpdate)((StreamProcessorSettingsForUpdate.Builder)StreamProcessorSettingsForUpdate.builder().applyMutation(settingsForUpdate)).build());
        }

        public Builder regionsOfInterestForUpdate(Collection<RegionOfInterest> var1);

        public Builder regionsOfInterestForUpdate(RegionOfInterest ... var1);

        public Builder regionsOfInterestForUpdate(Consumer<RegionOfInterest.Builder> ... var1);

        public Builder dataSharingPreferenceForUpdate(StreamProcessorDataSharingPreference var1);

        default public Builder dataSharingPreferenceForUpdate(Consumer<StreamProcessorDataSharingPreference.Builder> dataSharingPreferenceForUpdate) {
            return this.dataSharingPreferenceForUpdate((StreamProcessorDataSharingPreference)((StreamProcessorDataSharingPreference.Builder)StreamProcessorDataSharingPreference.builder().applyMutation(dataSharingPreferenceForUpdate)).build());
        }

        public Builder parametersToDeleteWithStrings(Collection<String> var1);

        public Builder parametersToDeleteWithStrings(String ... var1);

        public Builder parametersToDelete(Collection<StreamProcessorParameterToDelete> var1);

        public Builder parametersToDelete(StreamProcessorParameterToDelete ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

