/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rekognition.model.DetectLabelsImageProperties;
import software.amazon.awssdk.services.rekognition.model.Label;
import software.amazon.awssdk.services.rekognition.model.LabelsCopier;
import software.amazon.awssdk.services.rekognition.model.OrientationCorrection;
import software.amazon.awssdk.services.rekognition.model.RekognitionResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DetectLabelsResponse
extends RekognitionResponse
implements ToCopyableBuilder<Builder, DetectLabelsResponse> {
    private static final SdkField<List<Label>> LABELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Labels").getter(DetectLabelsResponse.getter(DetectLabelsResponse::labels)).setter(DetectLabelsResponse.setter(Builder::labels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Labels").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Label::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ORIENTATION_CORRECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OrientationCorrection").getter(DetectLabelsResponse.getter(DetectLabelsResponse::orientationCorrectionAsString)).setter(DetectLabelsResponse.setter(Builder::orientationCorrection)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrientationCorrection").build()}).build();
    private static final SdkField<String> LABEL_MODEL_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LabelModelVersion").getter(DetectLabelsResponse.getter(DetectLabelsResponse::labelModelVersion)).setter(DetectLabelsResponse.setter(Builder::labelModelVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelModelVersion").build()}).build();
    private static final SdkField<DetectLabelsImageProperties> IMAGE_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ImageProperties").getter(DetectLabelsResponse.getter(DetectLabelsResponse::imageProperties)).setter(DetectLabelsResponse.setter(Builder::imageProperties)).constructor(DetectLabelsImageProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageProperties").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LABELS_FIELD, ORIENTATION_CORRECTION_FIELD, LABEL_MODEL_VERSION_FIELD, IMAGE_PROPERTIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Labels", LABELS_FIELD);
            this.put("OrientationCorrection", ORIENTATION_CORRECTION_FIELD);
            this.put("LabelModelVersion", LABEL_MODEL_VERSION_FIELD);
            this.put("ImageProperties", IMAGE_PROPERTIES_FIELD);
        }
    });
    private final List<Label> labels;
    private final String orientationCorrection;
    private final String labelModelVersion;
    private final DetectLabelsImageProperties imageProperties;

    private DetectLabelsResponse(BuilderImpl builder) {
        super(builder);
        this.labels = builder.labels;
        this.orientationCorrection = builder.orientationCorrection;
        this.labelModelVersion = builder.labelModelVersion;
        this.imageProperties = builder.imageProperties;
    }

    public final boolean hasLabels() {
        return this.labels != null && !(this.labels instanceof SdkAutoConstructList);
    }

    public final List<Label> labels() {
        return this.labels;
    }

    public final OrientationCorrection orientationCorrection() {
        return OrientationCorrection.fromValue(this.orientationCorrection);
    }

    public final String orientationCorrectionAsString() {
        return this.orientationCorrection;
    }

    public final String labelModelVersion() {
        return this.labelModelVersion;
    }

    public final DetectLabelsImageProperties imageProperties() {
        return this.imageProperties;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLabels() ? this.labels() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.orientationCorrectionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.labelModelVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageProperties());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectLabelsResponse)) {
            return false;
        }
        DetectLabelsResponse other = (DetectLabelsResponse)((Object)obj);
        return this.hasLabels() == other.hasLabels() && Objects.equals(this.labels(), other.labels()) && Objects.equals(this.orientationCorrectionAsString(), other.orientationCorrectionAsString()) && Objects.equals(this.labelModelVersion(), other.labelModelVersion()) && Objects.equals(this.imageProperties(), other.imageProperties());
    }

    public final String toString() {
        return ToString.builder((String)"DetectLabelsResponse").add("Labels", this.hasLabels() ? this.labels() : null).add("OrientationCorrection", (Object)this.orientationCorrectionAsString()).add("LabelModelVersion", (Object)this.labelModelVersion()).add("ImageProperties", (Object)this.imageProperties()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Labels": {
                return Optional.ofNullable(clazz.cast(this.labels()));
            }
            case "OrientationCorrection": {
                return Optional.ofNullable(clazz.cast(this.orientationCorrectionAsString()));
            }
            case "LabelModelVersion": {
                return Optional.ofNullable(clazz.cast(this.labelModelVersion()));
            }
            case "ImageProperties": {
                return Optional.ofNullable(clazz.cast(this.imageProperties()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DetectLabelsResponse, T> g) {
        return obj -> g.apply((DetectLabelsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RekognitionResponse.BuilderImpl
    implements Builder {
        private List<Label> labels = DefaultSdkAutoConstructList.getInstance();
        private String orientationCorrection;
        private String labelModelVersion;
        private DetectLabelsImageProperties imageProperties;

        private BuilderImpl() {
        }

        private BuilderImpl(DetectLabelsResponse model) {
            super(model);
            this.labels(model.labels);
            this.orientationCorrection(model.orientationCorrection);
            this.labelModelVersion(model.labelModelVersion);
            this.imageProperties(model.imageProperties);
        }

        public final List<Label.Builder> getLabels() {
            List<Label.Builder> result = LabelsCopier.copyToBuilder(this.labels);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLabels(Collection<Label.BuilderImpl> labels) {
            this.labels = LabelsCopier.copyFromBuilder(labels);
        }

        @Override
        public final Builder labels(Collection<Label> labels) {
            this.labels = LabelsCopier.copy(labels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder labels(Label ... labels) {
            this.labels(Arrays.asList(labels));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder labels(Consumer<Label.Builder> ... labels) {
            this.labels(Stream.of(labels).map(c -> (Label)((Label.Builder)Label.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getOrientationCorrection() {
            return this.orientationCorrection;
        }

        public final void setOrientationCorrection(String orientationCorrection) {
            this.orientationCorrection = orientationCorrection;
        }

        @Override
        public final Builder orientationCorrection(String orientationCorrection) {
            this.orientationCorrection = orientationCorrection;
            return this;
        }

        @Override
        public final Builder orientationCorrection(OrientationCorrection orientationCorrection) {
            this.orientationCorrection(orientationCorrection == null ? null : orientationCorrection.toString());
            return this;
        }

        public final String getLabelModelVersion() {
            return this.labelModelVersion;
        }

        public final void setLabelModelVersion(String labelModelVersion) {
            this.labelModelVersion = labelModelVersion;
        }

        @Override
        public final Builder labelModelVersion(String labelModelVersion) {
            this.labelModelVersion = labelModelVersion;
            return this;
        }

        public final DetectLabelsImageProperties.Builder getImageProperties() {
            return this.imageProperties != null ? this.imageProperties.toBuilder() : null;
        }

        public final void setImageProperties(DetectLabelsImageProperties.BuilderImpl imageProperties) {
            this.imageProperties = imageProperties != null ? imageProperties.build() : null;
        }

        @Override
        public final Builder imageProperties(DetectLabelsImageProperties imageProperties) {
            this.imageProperties = imageProperties;
            return this;
        }

        @Override
        public DetectLabelsResponse build() {
            return new DetectLabelsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends RekognitionResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DetectLabelsResponse> {
        public Builder labels(Collection<Label> var1);

        public Builder labels(Label ... var1);

        public Builder labels(Consumer<Label.Builder> ... var1);

        public Builder orientationCorrection(String var1);

        public Builder orientationCorrection(OrientationCorrection var1);

        public Builder labelModelVersion(String var1);

        public Builder imageProperties(DetectLabelsImageProperties var1);

        default public Builder imageProperties(Consumer<DetectLabelsImageProperties.Builder> imageProperties) {
            return this.imageProperties((DetectLabelsImageProperties)((DetectLabelsImageProperties.Builder)DetectLabelsImageProperties.builder().applyMutation(imageProperties)).build());
        }
    }
}

