/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.rekognition.model.S3Object;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Image
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Image> {
    private static final SdkField<SdkBytes> BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("Bytes").getter(Image.getter(Image::bytes)).setter(Image.setter(Builder::bytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Bytes").build()}).build();
    private static final SdkField<S3Object> S3_OBJECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("S3Object").getter(Image.getter(Image::s3Object)).setter(Image.setter(Builder::s3Object)).constructor(S3Object::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Object").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BYTES_FIELD, S3_OBJECT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Bytes", BYTES_FIELD);
            this.put("S3Object", S3_OBJECT_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final SdkBytes bytes;
    private final S3Object s3Object;

    private Image(BuilderImpl builder) {
        this.bytes = builder.bytes;
        this.s3Object = builder.s3Object;
    }

    public final SdkBytes bytes() {
        return this.bytes;
    }

    public final S3Object s3Object() {
        return this.s3Object;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Object());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Image)) {
            return false;
        }
        Image other = (Image)obj;
        return Objects.equals(this.bytes(), other.bytes()) && Objects.equals(this.s3Object(), other.s3Object());
    }

    public final String toString() {
        return ToString.builder((String)"Image").add("Bytes", (Object)this.bytes()).add("S3Object", (Object)this.s3Object()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Bytes": {
                return Optional.ofNullable(clazz.cast(this.bytes()));
            }
            case "S3Object": {
                return Optional.ofNullable(clazz.cast(this.s3Object()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Image, T> g) {
        return obj -> g.apply((Image)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private SdkBytes bytes;
        private S3Object s3Object;

        private BuilderImpl() {
        }

        private BuilderImpl(Image model) {
            this.bytes(model.bytes);
            this.s3Object(model.s3Object);
        }

        public final ByteBuffer getBytes() {
            return this.bytes == null ? null : this.bytes.asByteBuffer();
        }

        public final void setBytes(ByteBuffer bytes) {
            this.bytes(bytes == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)bytes));
        }

        @Override
        public final Builder bytes(SdkBytes bytes) {
            this.bytes = bytes;
            return this;
        }

        public final S3Object.Builder getS3Object() {
            return this.s3Object != null ? this.s3Object.toBuilder() : null;
        }

        public final void setS3Object(S3Object.BuilderImpl s3Object) {
            this.s3Object = s3Object != null ? s3Object.build() : null;
        }

        @Override
        public final Builder s3Object(S3Object s3Object) {
            this.s3Object = s3Object;
            return this;
        }

        public Image build() {
            return new Image(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Image> {
        public Builder bytes(SdkBytes var1);

        public Builder s3Object(S3Object var1);

        default public Builder s3Object(Consumer<S3Object.Builder> s3Object) {
            return this.s3Object((S3Object)((S3Object.Builder)S3Object.builder().applyMutation(s3Object)).build());
        }
    }
}

