/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rekognition.model.DetectLabelsImageBackground;
import software.amazon.awssdk.services.rekognition.model.DetectLabelsImageForeground;
import software.amazon.awssdk.services.rekognition.model.DetectLabelsImageQuality;
import software.amazon.awssdk.services.rekognition.model.DominantColor;
import software.amazon.awssdk.services.rekognition.model.DominantColorsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DetectLabelsImageProperties
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DetectLabelsImageProperties> {
    private static final SdkField<DetectLabelsImageQuality> QUALITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Quality").getter(DetectLabelsImageProperties.getter(DetectLabelsImageProperties::quality)).setter(DetectLabelsImageProperties.setter(Builder::quality)).constructor(DetectLabelsImageQuality::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Quality").build()}).build();
    private static final SdkField<List<DominantColor>> DOMINANT_COLORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DominantColors").getter(DetectLabelsImageProperties.getter(DetectLabelsImageProperties::dominantColors)).setter(DetectLabelsImageProperties.setter(Builder::dominantColors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DominantColors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DominantColor::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<DetectLabelsImageForeground> FOREGROUND_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Foreground").getter(DetectLabelsImageProperties.getter(DetectLabelsImageProperties::foreground)).setter(DetectLabelsImageProperties.setter(Builder::foreground)).constructor(DetectLabelsImageForeground::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Foreground").build()}).build();
    private static final SdkField<DetectLabelsImageBackground> BACKGROUND_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Background").getter(DetectLabelsImageProperties.getter(DetectLabelsImageProperties::background)).setter(DetectLabelsImageProperties.setter(Builder::background)).constructor(DetectLabelsImageBackground::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Background").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUALITY_FIELD, DOMINANT_COLORS_FIELD, FOREGROUND_FIELD, BACKGROUND_FIELD));
    private static final long serialVersionUID = 1L;
    private final DetectLabelsImageQuality quality;
    private final List<DominantColor> dominantColors;
    private final DetectLabelsImageForeground foreground;
    private final DetectLabelsImageBackground background;

    private DetectLabelsImageProperties(BuilderImpl builder) {
        this.quality = builder.quality;
        this.dominantColors = builder.dominantColors;
        this.foreground = builder.foreground;
        this.background = builder.background;
    }

    public final DetectLabelsImageQuality quality() {
        return this.quality;
    }

    public final boolean hasDominantColors() {
        return this.dominantColors != null && !(this.dominantColors instanceof SdkAutoConstructList);
    }

    public final List<DominantColor> dominantColors() {
        return this.dominantColors;
    }

    public final DetectLabelsImageForeground foreground() {
        return this.foreground;
    }

    public final DetectLabelsImageBackground background() {
        return this.background;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.quality());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDominantColors() ? this.dominantColors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.foreground());
        hashCode = 31 * hashCode + Objects.hashCode(this.background());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectLabelsImageProperties)) {
            return false;
        }
        DetectLabelsImageProperties other = (DetectLabelsImageProperties)obj;
        return Objects.equals(this.quality(), other.quality()) && this.hasDominantColors() == other.hasDominantColors() && Objects.equals(this.dominantColors(), other.dominantColors()) && Objects.equals(this.foreground(), other.foreground()) && Objects.equals(this.background(), other.background());
    }

    public final String toString() {
        return ToString.builder((String)"DetectLabelsImageProperties").add("Quality", (Object)this.quality()).add("DominantColors", this.hasDominantColors() ? this.dominantColors() : null).add("Foreground", (Object)this.foreground()).add("Background", (Object)this.background()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Quality": {
                return Optional.ofNullable(clazz.cast(this.quality()));
            }
            case "DominantColors": {
                return Optional.ofNullable(clazz.cast(this.dominantColors()));
            }
            case "Foreground": {
                return Optional.ofNullable(clazz.cast(this.foreground()));
            }
            case "Background": {
                return Optional.ofNullable(clazz.cast(this.background()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DetectLabelsImageProperties, T> g) {
        return obj -> g.apply((DetectLabelsImageProperties)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private DetectLabelsImageQuality quality;
        private List<DominantColor> dominantColors = DefaultSdkAutoConstructList.getInstance();
        private DetectLabelsImageForeground foreground;
        private DetectLabelsImageBackground background;

        private BuilderImpl() {
        }

        private BuilderImpl(DetectLabelsImageProperties model) {
            this.quality(model.quality);
            this.dominantColors(model.dominantColors);
            this.foreground(model.foreground);
            this.background(model.background);
        }

        public final DetectLabelsImageQuality.Builder getQuality() {
            return this.quality != null ? this.quality.toBuilder() : null;
        }

        public final void setQuality(DetectLabelsImageQuality.BuilderImpl quality) {
            this.quality = quality != null ? quality.build() : null;
        }

        @Override
        public final Builder quality(DetectLabelsImageQuality quality) {
            this.quality = quality;
            return this;
        }

        public final List<DominantColor.Builder> getDominantColors() {
            List<DominantColor.Builder> result = DominantColorsCopier.copyToBuilder(this.dominantColors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDominantColors(Collection<DominantColor.BuilderImpl> dominantColors) {
            this.dominantColors = DominantColorsCopier.copyFromBuilder(dominantColors);
        }

        @Override
        public final Builder dominantColors(Collection<DominantColor> dominantColors) {
            this.dominantColors = DominantColorsCopier.copy(dominantColors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dominantColors(DominantColor ... dominantColors) {
            this.dominantColors(Arrays.asList(dominantColors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dominantColors(Consumer<DominantColor.Builder> ... dominantColors) {
            this.dominantColors(Stream.of(dominantColors).map(c -> (DominantColor)((DominantColor.Builder)DominantColor.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final DetectLabelsImageForeground.Builder getForeground() {
            return this.foreground != null ? this.foreground.toBuilder() : null;
        }

        public final void setForeground(DetectLabelsImageForeground.BuilderImpl foreground) {
            this.foreground = foreground != null ? foreground.build() : null;
        }

        @Override
        public final Builder foreground(DetectLabelsImageForeground foreground) {
            this.foreground = foreground;
            return this;
        }

        public final DetectLabelsImageBackground.Builder getBackground() {
            return this.background != null ? this.background.toBuilder() : null;
        }

        public final void setBackground(DetectLabelsImageBackground.BuilderImpl background) {
            this.background = background != null ? background.build() : null;
        }

        @Override
        public final Builder background(DetectLabelsImageBackground background) {
            this.background = background;
            return this;
        }

        public DetectLabelsImageProperties build() {
            return new DetectLabelsImageProperties(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DetectLabelsImageProperties> {
        public Builder quality(DetectLabelsImageQuality var1);

        default public Builder quality(Consumer<DetectLabelsImageQuality.Builder> quality) {
            return this.quality((DetectLabelsImageQuality)((DetectLabelsImageQuality.Builder)DetectLabelsImageQuality.builder().applyMutation(quality)).build());
        }

        public Builder dominantColors(Collection<DominantColor> var1);

        public Builder dominantColors(DominantColor ... var1);

        public Builder dominantColors(Consumer<DominantColor.Builder> ... var1);

        public Builder foreground(DetectLabelsImageForeground var1);

        default public Builder foreground(Consumer<DetectLabelsImageForeground.Builder> foreground) {
            return this.foreground((DetectLabelsImageForeground)((DetectLabelsImageForeground.Builder)DetectLabelsImageForeground.builder().applyMutation(foreground)).build());
        }

        public Builder background(DetectLabelsImageBackground var1);

        default public Builder background(Consumer<DetectLabelsImageBackground.Builder> background) {
            return this.background((DetectLabelsImageBackground)((DetectLabelsImageBackground.Builder)DetectLabelsImageBackground.builder().applyMutation(background)).build());
        }
    }
}

