/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum MediaAnalysisJobFailureCode {
    INTERNAL_ERROR("INTERNAL_ERROR"),
    INVALID_S3_OBJECT("INVALID_S3_OBJECT"),
    INVALID_MANIFEST("INVALID_MANIFEST"),
    INVALID_OUTPUT_CONFIG("INVALID_OUTPUT_CONFIG"),
    INVALID_KMS_KEY("INVALID_KMS_KEY"),
    ACCESS_DENIED("ACCESS_DENIED"),
    RESOURCE_NOT_FOUND("RESOURCE_NOT_FOUND"),
    RESOURCE_NOT_READY("RESOURCE_NOT_READY"),
    THROTTLED("THROTTLED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, MediaAnalysisJobFailureCode> VALUE_MAP;
    private final String value;

    private MediaAnalysisJobFailureCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static MediaAnalysisJobFailureCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<MediaAnalysisJobFailureCode> knownValues() {
        EnumSet<MediaAnalysisJobFailureCode> knownValues = EnumSet.allOf(MediaAnalysisJobFailureCode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(MediaAnalysisJobFailureCode.class, MediaAnalysisJobFailureCode::toString);
    }
}

