/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum UnsuccessfulFaceAssociationReason {
    FACE_NOT_FOUND("FACE_NOT_FOUND"),
    ASSOCIATED_TO_A_DIFFERENT_USER("ASSOCIATED_TO_A_DIFFERENT_USER"),
    LOW_MATCH_CONFIDENCE("LOW_MATCH_CONFIDENCE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, UnsuccessfulFaceAssociationReason> VALUE_MAP;
    private final String value;

    private UnsuccessfulFaceAssociationReason(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static UnsuccessfulFaceAssociationReason fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<UnsuccessfulFaceAssociationReason> knownValues() {
        EnumSet<UnsuccessfulFaceAssociationReason> knownValues = EnumSet.allOf(UnsuccessfulFaceAssociationReason.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(UnsuccessfulFaceAssociationReason.class, UnsuccessfulFaceAssociationReason::toString);
    }
}

