/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains data regarding the input face used for a search.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchedFaceDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<SearchedFaceDetails.Builder, SearchedFaceDetails> {
    private static final SdkField<FaceDetail> FACE_DETAIL_FIELD = SdkField.<FaceDetail> builder(MarshallingType.SDK_POJO)
            .memberName("FaceDetail").getter(getter(SearchedFaceDetails::faceDetail)).setter(setter(Builder::faceDetail))
            .constructor(FaceDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FaceDetail").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FACE_DETAIL_FIELD));

    private static final long serialVersionUID = 1L;

    private final FaceDetail faceDetail;

    private SearchedFaceDetails(BuilderImpl builder) {
        this.faceDetail = builder.faceDetail;
    }

    /**
     * Returns the value of the FaceDetail property for this object.
     * 
     * @return The value of the FaceDetail property for this object.
     */
    public final FaceDetail faceDetail() {
        return faceDetail;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(faceDetail());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchedFaceDetails)) {
            return false;
        }
        SearchedFaceDetails other = (SearchedFaceDetails) obj;
        return Objects.equals(faceDetail(), other.faceDetail());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SearchedFaceDetails").add("FaceDetail", faceDetail()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FaceDetail":
            return Optional.ofNullable(clazz.cast(faceDetail()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchedFaceDetails, T> g) {
        return obj -> g.apply((SearchedFaceDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SearchedFaceDetails> {
        /**
         * Sets the value of the FaceDetail property for this object.
         *
         * @param faceDetail
         *        The new value for the FaceDetail property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder faceDetail(FaceDetail faceDetail);

        /**
         * Sets the value of the FaceDetail property for this object.
         *
         * This is a convenience method that creates an instance of the {@link FaceDetail.Builder} avoiding the need to
         * create one manually via {@link FaceDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FaceDetail.Builder#build()} is called immediately and its result
         * is passed to {@link #faceDetail(FaceDetail)}.
         * 
         * @param faceDetail
         *        a consumer that will call methods on {@link FaceDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #faceDetail(FaceDetail)
         */
        default Builder faceDetail(Consumer<FaceDetail.Builder> faceDetail) {
            return faceDetail(FaceDetail.builder().applyMutation(faceDetail).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private FaceDetail faceDetail;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchedFaceDetails model) {
            faceDetail(model.faceDetail);
        }

        public final FaceDetail.Builder getFaceDetail() {
            return faceDetail != null ? faceDetail.toBuilder() : null;
        }

        public final void setFaceDetail(FaceDetail.BuilderImpl faceDetail) {
            this.faceDetail = faceDetail != null ? faceDetail.build() : null;
        }

        @Override
        public final Builder faceDetail(FaceDetail faceDetail) {
            this.faceDetail = faceDetail;
            return this;
        }

        @Override
        public SearchedFaceDetails build() {
            return new SearchedFaceDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
