/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A description of a version of an Amazon Rekognition Custom Labels model.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProjectVersionDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<ProjectVersionDescription.Builder, ProjectVersionDescription> {
    private static final SdkField<String> PROJECT_VERSION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProjectVersionArn").getter(getter(ProjectVersionDescription::projectVersionArn))
            .setter(setter(Builder::projectVersionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProjectVersionArn").build()).build();

    private static final SdkField<Instant> CREATION_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTimestamp").getter(getter(ProjectVersionDescription::creationTimestamp))
            .setter(setter(Builder::creationTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTimestamp").build()).build();

    private static final SdkField<Integer> MIN_INFERENCE_UNITS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MinInferenceUnits").getter(getter(ProjectVersionDescription::minInferenceUnits))
            .setter(setter(Builder::minInferenceUnits))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinInferenceUnits").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(ProjectVersionDescription::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusMessage").getter(getter(ProjectVersionDescription::statusMessage))
            .setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()).build();

    private static final SdkField<Long> BILLABLE_TRAINING_TIME_IN_SECONDS_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("BillableTrainingTimeInSeconds")
            .getter(getter(ProjectVersionDescription::billableTrainingTimeInSeconds))
            .setter(setter(Builder::billableTrainingTimeInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BillableTrainingTimeInSeconds")
                    .build()).build();

    private static final SdkField<Instant> TRAINING_END_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("TrainingEndTimestamp").getter(getter(ProjectVersionDescription::trainingEndTimestamp))
            .setter(setter(Builder::trainingEndTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingEndTimestamp").build())
            .build();

    private static final SdkField<OutputConfig> OUTPUT_CONFIG_FIELD = SdkField.<OutputConfig> builder(MarshallingType.SDK_POJO)
            .memberName("OutputConfig").getter(getter(ProjectVersionDescription::outputConfig))
            .setter(setter(Builder::outputConfig)).constructor(OutputConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputConfig").build()).build();

    private static final SdkField<TrainingDataResult> TRAINING_DATA_RESULT_FIELD = SdkField
            .<TrainingDataResult> builder(MarshallingType.SDK_POJO).memberName("TrainingDataResult")
            .getter(getter(ProjectVersionDescription::trainingDataResult)).setter(setter(Builder::trainingDataResult))
            .constructor(TrainingDataResult::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingDataResult").build())
            .build();

    private static final SdkField<TestingDataResult> TESTING_DATA_RESULT_FIELD = SdkField
            .<TestingDataResult> builder(MarshallingType.SDK_POJO).memberName("TestingDataResult")
            .getter(getter(ProjectVersionDescription::testingDataResult)).setter(setter(Builder::testingDataResult))
            .constructor(TestingDataResult::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TestingDataResult").build()).build();

    private static final SdkField<EvaluationResult> EVALUATION_RESULT_FIELD = SdkField
            .<EvaluationResult> builder(MarshallingType.SDK_POJO).memberName("EvaluationResult")
            .getter(getter(ProjectVersionDescription::evaluationResult)).setter(setter(Builder::evaluationResult))
            .constructor(EvaluationResult::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationResult").build()).build();

    private static final SdkField<GroundTruthManifest> MANIFEST_SUMMARY_FIELD = SdkField
            .<GroundTruthManifest> builder(MarshallingType.SDK_POJO).memberName("ManifestSummary")
            .getter(getter(ProjectVersionDescription::manifestSummary)).setter(setter(Builder::manifestSummary))
            .constructor(GroundTruthManifest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManifestSummary").build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyId").getter(getter(ProjectVersionDescription::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()).build();

    private static final SdkField<Integer> MAX_INFERENCE_UNITS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxInferenceUnits").getter(getter(ProjectVersionDescription::maxInferenceUnits))
            .setter(setter(Builder::maxInferenceUnits))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxInferenceUnits").build()).build();

    private static final SdkField<String> SOURCE_PROJECT_VERSION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceProjectVersionArn").getter(getter(ProjectVersionDescription::sourceProjectVersionArn))
            .setter(setter(Builder::sourceProjectVersionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceProjectVersionArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROJECT_VERSION_ARN_FIELD,
            CREATION_TIMESTAMP_FIELD, MIN_INFERENCE_UNITS_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD,
            BILLABLE_TRAINING_TIME_IN_SECONDS_FIELD, TRAINING_END_TIMESTAMP_FIELD, OUTPUT_CONFIG_FIELD,
            TRAINING_DATA_RESULT_FIELD, TESTING_DATA_RESULT_FIELD, EVALUATION_RESULT_FIELD, MANIFEST_SUMMARY_FIELD,
            KMS_KEY_ID_FIELD, MAX_INFERENCE_UNITS_FIELD, SOURCE_PROJECT_VERSION_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String projectVersionArn;

    private final Instant creationTimestamp;

    private final Integer minInferenceUnits;

    private final String status;

    private final String statusMessage;

    private final Long billableTrainingTimeInSeconds;

    private final Instant trainingEndTimestamp;

    private final OutputConfig outputConfig;

    private final TrainingDataResult trainingDataResult;

    private final TestingDataResult testingDataResult;

    private final EvaluationResult evaluationResult;

    private final GroundTruthManifest manifestSummary;

    private final String kmsKeyId;

    private final Integer maxInferenceUnits;

    private final String sourceProjectVersionArn;

    private ProjectVersionDescription(BuilderImpl builder) {
        this.projectVersionArn = builder.projectVersionArn;
        this.creationTimestamp = builder.creationTimestamp;
        this.minInferenceUnits = builder.minInferenceUnits;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.billableTrainingTimeInSeconds = builder.billableTrainingTimeInSeconds;
        this.trainingEndTimestamp = builder.trainingEndTimestamp;
        this.outputConfig = builder.outputConfig;
        this.trainingDataResult = builder.trainingDataResult;
        this.testingDataResult = builder.testingDataResult;
        this.evaluationResult = builder.evaluationResult;
        this.manifestSummary = builder.manifestSummary;
        this.kmsKeyId = builder.kmsKeyId;
        this.maxInferenceUnits = builder.maxInferenceUnits;
        this.sourceProjectVersionArn = builder.sourceProjectVersionArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the model version.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the model version.
     */
    public final String projectVersionArn() {
        return projectVersionArn;
    }

    /**
     * <p>
     * The Unix datetime for the date and time that training started.
     * </p>
     * 
     * @return The Unix datetime for the date and time that training started.
     */
    public final Instant creationTimestamp() {
        return creationTimestamp;
    }

    /**
     * <p>
     * The minimum number of inference units used by the model. For more information, see <a>StartProjectVersion</a>.
     * </p>
     * 
     * @return The minimum number of inference units used by the model. For more information, see
     *         <a>StartProjectVersion</a>.
     */
    public final Integer minInferenceUnits() {
        return minInferenceUnits;
    }

    /**
     * <p>
     * The current status of the model version.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ProjectVersionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the model version.
     * @see ProjectVersionStatus
     */
    public final ProjectVersionStatus status() {
        return ProjectVersionStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the model version.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ProjectVersionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the model version.
     * @see ProjectVersionStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * A descriptive message for an error or warning that occurred.
     * </p>
     * 
     * @return A descriptive message for an error or warning that occurred.
     */
    public final String statusMessage() {
        return statusMessage;
    }

    /**
     * <p>
     * The duration, in seconds, that you were billed for a successful training of the model version. This value is only
     * returned if the model version has been successfully trained.
     * </p>
     * 
     * @return The duration, in seconds, that you were billed for a successful training of the model version. This value
     *         is only returned if the model version has been successfully trained.
     */
    public final Long billableTrainingTimeInSeconds() {
        return billableTrainingTimeInSeconds;
    }

    /**
     * <p>
     * The Unix date and time that training of the model ended.
     * </p>
     * 
     * @return The Unix date and time that training of the model ended.
     */
    public final Instant trainingEndTimestamp() {
        return trainingEndTimestamp;
    }

    /**
     * <p>
     * The location where training results are saved.
     * </p>
     * 
     * @return The location where training results are saved.
     */
    public final OutputConfig outputConfig() {
        return outputConfig;
    }

    /**
     * <p>
     * Contains information about the training results.
     * </p>
     * 
     * @return Contains information about the training results.
     */
    public final TrainingDataResult trainingDataResult() {
        return trainingDataResult;
    }

    /**
     * <p>
     * Contains information about the testing results.
     * </p>
     * 
     * @return Contains information about the testing results.
     */
    public final TestingDataResult testingDataResult() {
        return testingDataResult;
    }

    /**
     * <p>
     * The training results. <code>EvaluationResult</code> is only returned if training is successful.
     * </p>
     * 
     * @return The training results. <code>EvaluationResult</code> is only returned if training is successful.
     */
    public final EvaluationResult evaluationResult() {
        return evaluationResult;
    }

    /**
     * <p>
     * The location of the summary manifest. The summary manifest provides aggregate data validation results for the
     * training and test datasets.
     * </p>
     * 
     * @return The location of the summary manifest. The summary manifest provides aggregate data validation results for
     *         the training and test datasets.
     */
    public final GroundTruthManifest manifestSummary() {
        return manifestSummary;
    }

    /**
     * <p>
     * The identifer for the AWS Key Management Service key (AWS KMS key) that was used to encrypt the model during
     * training.
     * </p>
     * 
     * @return The identifer for the AWS Key Management Service key (AWS KMS key) that was used to encrypt the model
     *         during training.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * The maximum number of inference units Amazon Rekognition Custom Labels uses to auto-scale the model. For more
     * information, see <a>StartProjectVersion</a>.
     * </p>
     * 
     * @return The maximum number of inference units Amazon Rekognition Custom Labels uses to auto-scale the model. For
     *         more information, see <a>StartProjectVersion</a>.
     */
    public final Integer maxInferenceUnits() {
        return maxInferenceUnits;
    }

    /**
     * <p>
     * If the model version was copied from a different project, <code>SourceProjectVersionArn</code> contains the ARN
     * of the source model version.
     * </p>
     * 
     * @return If the model version was copied from a different project, <code>SourceProjectVersionArn</code> contains
     *         the ARN of the source model version.
     */
    public final String sourceProjectVersionArn() {
        return sourceProjectVersionArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(projectVersionArn());
        hashCode = 31 * hashCode + Objects.hashCode(creationTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(minInferenceUnits());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(billableTrainingTimeInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(trainingEndTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(outputConfig());
        hashCode = 31 * hashCode + Objects.hashCode(trainingDataResult());
        hashCode = 31 * hashCode + Objects.hashCode(testingDataResult());
        hashCode = 31 * hashCode + Objects.hashCode(evaluationResult());
        hashCode = 31 * hashCode + Objects.hashCode(manifestSummary());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(maxInferenceUnits());
        hashCode = 31 * hashCode + Objects.hashCode(sourceProjectVersionArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProjectVersionDescription)) {
            return false;
        }
        ProjectVersionDescription other = (ProjectVersionDescription) obj;
        return Objects.equals(projectVersionArn(), other.projectVersionArn())
                && Objects.equals(creationTimestamp(), other.creationTimestamp())
                && Objects.equals(minInferenceUnits(), other.minInferenceUnits())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusMessage(), other.statusMessage())
                && Objects.equals(billableTrainingTimeInSeconds(), other.billableTrainingTimeInSeconds())
                && Objects.equals(trainingEndTimestamp(), other.trainingEndTimestamp())
                && Objects.equals(outputConfig(), other.outputConfig())
                && Objects.equals(trainingDataResult(), other.trainingDataResult())
                && Objects.equals(testingDataResult(), other.testingDataResult())
                && Objects.equals(evaluationResult(), other.evaluationResult())
                && Objects.equals(manifestSummary(), other.manifestSummary()) && Objects.equals(kmsKeyId(), other.kmsKeyId())
                && Objects.equals(maxInferenceUnits(), other.maxInferenceUnits())
                && Objects.equals(sourceProjectVersionArn(), other.sourceProjectVersionArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProjectVersionDescription").add("ProjectVersionArn", projectVersionArn())
                .add("CreationTimestamp", creationTimestamp()).add("MinInferenceUnits", minInferenceUnits())
                .add("Status", statusAsString()).add("StatusMessage", statusMessage())
                .add("BillableTrainingTimeInSeconds", billableTrainingTimeInSeconds())
                .add("TrainingEndTimestamp", trainingEndTimestamp()).add("OutputConfig", outputConfig())
                .add("TrainingDataResult", trainingDataResult()).add("TestingDataResult", testingDataResult())
                .add("EvaluationResult", evaluationResult()).add("ManifestSummary", manifestSummary())
                .add("KmsKeyId", kmsKeyId()).add("MaxInferenceUnits", maxInferenceUnits())
                .add("SourceProjectVersionArn", sourceProjectVersionArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProjectVersionArn":
            return Optional.ofNullable(clazz.cast(projectVersionArn()));
        case "CreationTimestamp":
            return Optional.ofNullable(clazz.cast(creationTimestamp()));
        case "MinInferenceUnits":
            return Optional.ofNullable(clazz.cast(minInferenceUnits()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "StatusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        case "BillableTrainingTimeInSeconds":
            return Optional.ofNullable(clazz.cast(billableTrainingTimeInSeconds()));
        case "TrainingEndTimestamp":
            return Optional.ofNullable(clazz.cast(trainingEndTimestamp()));
        case "OutputConfig":
            return Optional.ofNullable(clazz.cast(outputConfig()));
        case "TrainingDataResult":
            return Optional.ofNullable(clazz.cast(trainingDataResult()));
        case "TestingDataResult":
            return Optional.ofNullable(clazz.cast(testingDataResult()));
        case "EvaluationResult":
            return Optional.ofNullable(clazz.cast(evaluationResult()));
        case "ManifestSummary":
            return Optional.ofNullable(clazz.cast(manifestSummary()));
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "MaxInferenceUnits":
            return Optional.ofNullable(clazz.cast(maxInferenceUnits()));
        case "SourceProjectVersionArn":
            return Optional.ofNullable(clazz.cast(sourceProjectVersionArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProjectVersionDescription, T> g) {
        return obj -> g.apply((ProjectVersionDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProjectVersionDescription> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the model version.
         * </p>
         * 
         * @param projectVersionArn
         *        The Amazon Resource Name (ARN) of the model version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectVersionArn(String projectVersionArn);

        /**
         * <p>
         * The Unix datetime for the date and time that training started.
         * </p>
         * 
         * @param creationTimestamp
         *        The Unix datetime for the date and time that training started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTimestamp(Instant creationTimestamp);

        /**
         * <p>
         * The minimum number of inference units used by the model. For more information, see
         * <a>StartProjectVersion</a>.
         * </p>
         * 
         * @param minInferenceUnits
         *        The minimum number of inference units used by the model. For more information, see
         *        <a>StartProjectVersion</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minInferenceUnits(Integer minInferenceUnits);

        /**
         * <p>
         * The current status of the model version.
         * </p>
         * 
         * @param status
         *        The current status of the model version.
         * @see ProjectVersionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProjectVersionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the model version.
         * </p>
         * 
         * @param status
         *        The current status of the model version.
         * @see ProjectVersionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProjectVersionStatus
         */
        Builder status(ProjectVersionStatus status);

        /**
         * <p>
         * A descriptive message for an error or warning that occurred.
         * </p>
         * 
         * @param statusMessage
         *        A descriptive message for an error or warning that occurred.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);

        /**
         * <p>
         * The duration, in seconds, that you were billed for a successful training of the model version. This value is
         * only returned if the model version has been successfully trained.
         * </p>
         * 
         * @param billableTrainingTimeInSeconds
         *        The duration, in seconds, that you were billed for a successful training of the model version. This
         *        value is only returned if the model version has been successfully trained.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder billableTrainingTimeInSeconds(Long billableTrainingTimeInSeconds);

        /**
         * <p>
         * The Unix date and time that training of the model ended.
         * </p>
         * 
         * @param trainingEndTimestamp
         *        The Unix date and time that training of the model ended.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trainingEndTimestamp(Instant trainingEndTimestamp);

        /**
         * <p>
         * The location where training results are saved.
         * </p>
         * 
         * @param outputConfig
         *        The location where training results are saved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputConfig(OutputConfig outputConfig);

        /**
         * <p>
         * The location where training results are saved.
         * </p>
         * This is a convenience method that creates an instance of the {@link OutputConfig.Builder} avoiding the need
         * to create one manually via {@link OutputConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OutputConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #outputConfig(OutputConfig)}.
         * 
         * @param outputConfig
         *        a consumer that will call methods on {@link OutputConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputConfig(OutputConfig)
         */
        default Builder outputConfig(Consumer<OutputConfig.Builder> outputConfig) {
            return outputConfig(OutputConfig.builder().applyMutation(outputConfig).build());
        }

        /**
         * <p>
         * Contains information about the training results.
         * </p>
         * 
         * @param trainingDataResult
         *        Contains information about the training results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trainingDataResult(TrainingDataResult trainingDataResult);

        /**
         * <p>
         * Contains information about the training results.
         * </p>
         * This is a convenience method that creates an instance of the {@link TrainingDataResult.Builder} avoiding the
         * need to create one manually via {@link TrainingDataResult#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TrainingDataResult.Builder#build()} is called immediately and its
         * result is passed to {@link #trainingDataResult(TrainingDataResult)}.
         * 
         * @param trainingDataResult
         *        a consumer that will call methods on {@link TrainingDataResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trainingDataResult(TrainingDataResult)
         */
        default Builder trainingDataResult(Consumer<TrainingDataResult.Builder> trainingDataResult) {
            return trainingDataResult(TrainingDataResult.builder().applyMutation(trainingDataResult).build());
        }

        /**
         * <p>
         * Contains information about the testing results.
         * </p>
         * 
         * @param testingDataResult
         *        Contains information about the testing results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testingDataResult(TestingDataResult testingDataResult);

        /**
         * <p>
         * Contains information about the testing results.
         * </p>
         * This is a convenience method that creates an instance of the {@link TestingDataResult.Builder} avoiding the
         * need to create one manually via {@link TestingDataResult#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TestingDataResult.Builder#build()} is called immediately and its
         * result is passed to {@link #testingDataResult(TestingDataResult)}.
         * 
         * @param testingDataResult
         *        a consumer that will call methods on {@link TestingDataResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #testingDataResult(TestingDataResult)
         */
        default Builder testingDataResult(Consumer<TestingDataResult.Builder> testingDataResult) {
            return testingDataResult(TestingDataResult.builder().applyMutation(testingDataResult).build());
        }

        /**
         * <p>
         * The training results. <code>EvaluationResult</code> is only returned if training is successful.
         * </p>
         * 
         * @param evaluationResult
         *        The training results. <code>EvaluationResult</code> is only returned if training is successful.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluationResult(EvaluationResult evaluationResult);

        /**
         * <p>
         * The training results. <code>EvaluationResult</code> is only returned if training is successful.
         * </p>
         * This is a convenience method that creates an instance of the {@link EvaluationResult.Builder} avoiding the
         * need to create one manually via {@link EvaluationResult#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EvaluationResult.Builder#build()} is called immediately and its
         * result is passed to {@link #evaluationResult(EvaluationResult)}.
         * 
         * @param evaluationResult
         *        a consumer that will call methods on {@link EvaluationResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #evaluationResult(EvaluationResult)
         */
        default Builder evaluationResult(Consumer<EvaluationResult.Builder> evaluationResult) {
            return evaluationResult(EvaluationResult.builder().applyMutation(evaluationResult).build());
        }

        /**
         * <p>
         * The location of the summary manifest. The summary manifest provides aggregate data validation results for the
         * training and test datasets.
         * </p>
         * 
         * @param manifestSummary
         *        The location of the summary manifest. The summary manifest provides aggregate data validation results
         *        for the training and test datasets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder manifestSummary(GroundTruthManifest manifestSummary);

        /**
         * <p>
         * The location of the summary manifest. The summary manifest provides aggregate data validation results for the
         * training and test datasets.
         * </p>
         * This is a convenience method that creates an instance of the {@link GroundTruthManifest.Builder} avoiding the
         * need to create one manually via {@link GroundTruthManifest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GroundTruthManifest.Builder#build()} is called immediately and
         * its result is passed to {@link #manifestSummary(GroundTruthManifest)}.
         * 
         * @param manifestSummary
         *        a consumer that will call methods on {@link GroundTruthManifest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #manifestSummary(GroundTruthManifest)
         */
        default Builder manifestSummary(Consumer<GroundTruthManifest.Builder> manifestSummary) {
            return manifestSummary(GroundTruthManifest.builder().applyMutation(manifestSummary).build());
        }

        /**
         * <p>
         * The identifer for the AWS Key Management Service key (AWS KMS key) that was used to encrypt the model during
         * training.
         * </p>
         * 
         * @param kmsKeyId
         *        The identifer for the AWS Key Management Service key (AWS KMS key) that was used to encrypt the model
         *        during training.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * The maximum number of inference units Amazon Rekognition Custom Labels uses to auto-scale the model. For more
         * information, see <a>StartProjectVersion</a>.
         * </p>
         * 
         * @param maxInferenceUnits
         *        The maximum number of inference units Amazon Rekognition Custom Labels uses to auto-scale the model.
         *        For more information, see <a>StartProjectVersion</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxInferenceUnits(Integer maxInferenceUnits);

        /**
         * <p>
         * If the model version was copied from a different project, <code>SourceProjectVersionArn</code> contains the
         * ARN of the source model version.
         * </p>
         * 
         * @param sourceProjectVersionArn
         *        If the model version was copied from a different project, <code>SourceProjectVersionArn</code>
         *        contains the ARN of the source model version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceProjectVersionArn(String sourceProjectVersionArn);
    }

    static final class BuilderImpl implements Builder {
        private String projectVersionArn;

        private Instant creationTimestamp;

        private Integer minInferenceUnits;

        private String status;

        private String statusMessage;

        private Long billableTrainingTimeInSeconds;

        private Instant trainingEndTimestamp;

        private OutputConfig outputConfig;

        private TrainingDataResult trainingDataResult;

        private TestingDataResult testingDataResult;

        private EvaluationResult evaluationResult;

        private GroundTruthManifest manifestSummary;

        private String kmsKeyId;

        private Integer maxInferenceUnits;

        private String sourceProjectVersionArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ProjectVersionDescription model) {
            projectVersionArn(model.projectVersionArn);
            creationTimestamp(model.creationTimestamp);
            minInferenceUnits(model.minInferenceUnits);
            status(model.status);
            statusMessage(model.statusMessage);
            billableTrainingTimeInSeconds(model.billableTrainingTimeInSeconds);
            trainingEndTimestamp(model.trainingEndTimestamp);
            outputConfig(model.outputConfig);
            trainingDataResult(model.trainingDataResult);
            testingDataResult(model.testingDataResult);
            evaluationResult(model.evaluationResult);
            manifestSummary(model.manifestSummary);
            kmsKeyId(model.kmsKeyId);
            maxInferenceUnits(model.maxInferenceUnits);
            sourceProjectVersionArn(model.sourceProjectVersionArn);
        }

        public final String getProjectVersionArn() {
            return projectVersionArn;
        }

        public final void setProjectVersionArn(String projectVersionArn) {
            this.projectVersionArn = projectVersionArn;
        }

        @Override
        public final Builder projectVersionArn(String projectVersionArn) {
            this.projectVersionArn = projectVersionArn;
            return this;
        }

        public final Instant getCreationTimestamp() {
            return creationTimestamp;
        }

        public final void setCreationTimestamp(Instant creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
        }

        @Override
        public final Builder creationTimestamp(Instant creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
            return this;
        }

        public final Integer getMinInferenceUnits() {
            return minInferenceUnits;
        }

        public final void setMinInferenceUnits(Integer minInferenceUnits) {
            this.minInferenceUnits = minInferenceUnits;
        }

        @Override
        public final Builder minInferenceUnits(Integer minInferenceUnits) {
            this.minInferenceUnits = minInferenceUnits;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ProjectVersionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final Long getBillableTrainingTimeInSeconds() {
            return billableTrainingTimeInSeconds;
        }

        public final void setBillableTrainingTimeInSeconds(Long billableTrainingTimeInSeconds) {
            this.billableTrainingTimeInSeconds = billableTrainingTimeInSeconds;
        }

        @Override
        public final Builder billableTrainingTimeInSeconds(Long billableTrainingTimeInSeconds) {
            this.billableTrainingTimeInSeconds = billableTrainingTimeInSeconds;
            return this;
        }

        public final Instant getTrainingEndTimestamp() {
            return trainingEndTimestamp;
        }

        public final void setTrainingEndTimestamp(Instant trainingEndTimestamp) {
            this.trainingEndTimestamp = trainingEndTimestamp;
        }

        @Override
        public final Builder trainingEndTimestamp(Instant trainingEndTimestamp) {
            this.trainingEndTimestamp = trainingEndTimestamp;
            return this;
        }

        public final OutputConfig.Builder getOutputConfig() {
            return outputConfig != null ? outputConfig.toBuilder() : null;
        }

        public final void setOutputConfig(OutputConfig.BuilderImpl outputConfig) {
            this.outputConfig = outputConfig != null ? outputConfig.build() : null;
        }

        @Override
        public final Builder outputConfig(OutputConfig outputConfig) {
            this.outputConfig = outputConfig;
            return this;
        }

        public final TrainingDataResult.Builder getTrainingDataResult() {
            return trainingDataResult != null ? trainingDataResult.toBuilder() : null;
        }

        public final void setTrainingDataResult(TrainingDataResult.BuilderImpl trainingDataResult) {
            this.trainingDataResult = trainingDataResult != null ? trainingDataResult.build() : null;
        }

        @Override
        public final Builder trainingDataResult(TrainingDataResult trainingDataResult) {
            this.trainingDataResult = trainingDataResult;
            return this;
        }

        public final TestingDataResult.Builder getTestingDataResult() {
            return testingDataResult != null ? testingDataResult.toBuilder() : null;
        }

        public final void setTestingDataResult(TestingDataResult.BuilderImpl testingDataResult) {
            this.testingDataResult = testingDataResult != null ? testingDataResult.build() : null;
        }

        @Override
        public final Builder testingDataResult(TestingDataResult testingDataResult) {
            this.testingDataResult = testingDataResult;
            return this;
        }

        public final EvaluationResult.Builder getEvaluationResult() {
            return evaluationResult != null ? evaluationResult.toBuilder() : null;
        }

        public final void setEvaluationResult(EvaluationResult.BuilderImpl evaluationResult) {
            this.evaluationResult = evaluationResult != null ? evaluationResult.build() : null;
        }

        @Override
        public final Builder evaluationResult(EvaluationResult evaluationResult) {
            this.evaluationResult = evaluationResult;
            return this;
        }

        public final GroundTruthManifest.Builder getManifestSummary() {
            return manifestSummary != null ? manifestSummary.toBuilder() : null;
        }

        public final void setManifestSummary(GroundTruthManifest.BuilderImpl manifestSummary) {
            this.manifestSummary = manifestSummary != null ? manifestSummary.build() : null;
        }

        @Override
        public final Builder manifestSummary(GroundTruthManifest manifestSummary) {
            this.manifestSummary = manifestSummary;
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final Integer getMaxInferenceUnits() {
            return maxInferenceUnits;
        }

        public final void setMaxInferenceUnits(Integer maxInferenceUnits) {
            this.maxInferenceUnits = maxInferenceUnits;
        }

        @Override
        public final Builder maxInferenceUnits(Integer maxInferenceUnits) {
            this.maxInferenceUnits = maxInferenceUnits;
            return this;
        }

        public final String getSourceProjectVersionArn() {
            return sourceProjectVersionArn;
        }

        public final void setSourceProjectVersionArn(String sourceProjectVersionArn) {
            this.sourceProjectVersionArn = sourceProjectVersionArn;
        }

        @Override
        public final Builder sourceProjectVersionArn(String sourceProjectVersionArn) {
            this.sourceProjectVersionArn = sourceProjectVersionArn;
            return this;
        }

        @Override
        public ProjectVersionDescription build() {
            return new ProjectVersionDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
