/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A custom label detected in an image by a call to <a>DetectCustomLabels</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CustomLabel implements SdkPojo, Serializable, ToCopyableBuilder<CustomLabel.Builder, CustomLabel> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CustomLabel::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<Float> CONFIDENCE_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .memberName("Confidence").getter(getter(CustomLabel::confidence)).setter(setter(Builder::confidence))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Confidence").build()).build();

    private static final SdkField<Geometry> GEOMETRY_FIELD = SdkField.<Geometry> builder(MarshallingType.SDK_POJO)
            .memberName("Geometry").getter(getter(CustomLabel::geometry)).setter(setter(Builder::geometry))
            .constructor(Geometry::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Geometry").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, CONFIDENCE_FIELD,
            GEOMETRY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final Float confidence;

    private final Geometry geometry;

    private CustomLabel(BuilderImpl builder) {
        this.name = builder.name;
        this.confidence = builder.confidence;
        this.geometry = builder.geometry;
    }

    /**
     * <p>
     * The name of the custom label.
     * </p>
     * 
     * @return The name of the custom label.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The confidence that the model has in the detection of the custom label. The range is 0-100. A higher value
     * indicates a higher confidence.
     * </p>
     * 
     * @return The confidence that the model has in the detection of the custom label. The range is 0-100. A higher
     *         value indicates a higher confidence.
     */
    public final Float confidence() {
        return confidence;
    }

    /**
     * <p>
     * The location of the detected object on the image that corresponds to the custom label. Includes an axis aligned
     * coarse bounding box surrounding the object and a finer grain polygon for more accurate spatial information.
     * </p>
     * 
     * @return The location of the detected object on the image that corresponds to the custom label. Includes an axis
     *         aligned coarse bounding box surrounding the object and a finer grain polygon for more accurate spatial
     *         information.
     */
    public final Geometry geometry() {
        return geometry;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(confidence());
        hashCode = 31 * hashCode + Objects.hashCode(geometry());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomLabel)) {
            return false;
        }
        CustomLabel other = (CustomLabel) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(confidence(), other.confidence())
                && Objects.equals(geometry(), other.geometry());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CustomLabel").add("Name", name()).add("Confidence", confidence()).add("Geometry", geometry())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Confidence":
            return Optional.ofNullable(clazz.cast(confidence()));
        case "Geometry":
            return Optional.ofNullable(clazz.cast(geometry()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CustomLabel, T> g) {
        return obj -> g.apply((CustomLabel) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CustomLabel> {
        /**
         * <p>
         * The name of the custom label.
         * </p>
         * 
         * @param name
         *        The name of the custom label.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The confidence that the model has in the detection of the custom label. The range is 0-100. A higher value
         * indicates a higher confidence.
         * </p>
         * 
         * @param confidence
         *        The confidence that the model has in the detection of the custom label. The range is 0-100. A higher
         *        value indicates a higher confidence.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder confidence(Float confidence);

        /**
         * <p>
         * The location of the detected object on the image that corresponds to the custom label. Includes an axis
         * aligned coarse bounding box surrounding the object and a finer grain polygon for more accurate spatial
         * information.
         * </p>
         * 
         * @param geometry
         *        The location of the detected object on the image that corresponds to the custom label. Includes an
         *        axis aligned coarse bounding box surrounding the object and a finer grain polygon for more accurate
         *        spatial information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder geometry(Geometry geometry);

        /**
         * <p>
         * The location of the detected object on the image that corresponds to the custom label. Includes an axis
         * aligned coarse bounding box surrounding the object and a finer grain polygon for more accurate spatial
         * information.
         * </p>
         * This is a convenience method that creates an instance of the {@link Geometry.Builder} avoiding the need to
         * create one manually via {@link Geometry#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Geometry.Builder#build()} is called immediately and its result is
         * passed to {@link #geometry(Geometry)}.
         * 
         * @param geometry
         *        a consumer that will call methods on {@link Geometry.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #geometry(Geometry)
         */
        default Builder geometry(Consumer<Geometry.Builder> geometry) {
            return geometry(Geometry.builder().applyMutation(geometry).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private Float confidence;

        private Geometry geometry;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomLabel model) {
            name(model.name);
            confidence(model.confidence);
            geometry(model.geometry);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Float getConfidence() {
            return confidence;
        }

        public final void setConfidence(Float confidence) {
            this.confidence = confidence;
        }

        @Override
        public final Builder confidence(Float confidence) {
            this.confidence = confidence;
            return this;
        }

        public final Geometry.Builder getGeometry() {
            return geometry != null ? geometry.toBuilder() : null;
        }

        public final void setGeometry(Geometry.BuilderImpl geometry) {
            this.geometry = geometry != null ? geometry.build() : null;
        }

        @Override
        public final Builder geometry(Geometry geometry) {
            this.geometry = geometry;
            return this;
        }

        @Override
        public CustomLabel build() {
            return new CustomLabel(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
