/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.rekognition.DefaultRekognitionAsyncClient;
import software.amazon.awssdk.services.rekognition.DefaultRekognitionBaseClientBuilder;
import software.amazon.awssdk.services.rekognition.RekognitionAsyncClient;
import software.amazon.awssdk.services.rekognition.RekognitionAsyncClientBuilder;
import software.amazon.awssdk.services.rekognition.RekognitionServiceClientConfiguration;
import software.amazon.awssdk.services.rekognition.endpoints.RekognitionEndpointProvider;

@SdkInternalApi
final class DefaultRekognitionAsyncClientBuilder
extends DefaultRekognitionBaseClientBuilder<RekognitionAsyncClientBuilder, RekognitionAsyncClient>
implements RekognitionAsyncClientBuilder {
    DefaultRekognitionAsyncClientBuilder() {
    }

    @Override
    public DefaultRekognitionAsyncClientBuilder endpointProvider(RekognitionEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final RekognitionAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultRekognitionAsyncClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        RekognitionServiceClientConfiguration serviceClientConfiguration = RekognitionServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultRekognitionAsyncClient(serviceClientConfiguration, clientConfiguration);
    }
}

