/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.rekognition.RekognitionClient;
import software.amazon.awssdk.services.rekognition.model.DatasetLabelDescription;
import software.amazon.awssdk.services.rekognition.model.ListDatasetLabelsRequest;
import software.amazon.awssdk.services.rekognition.model.ListDatasetLabelsResponse;

public class ListDatasetLabelsIterable
implements SdkIterable<ListDatasetLabelsResponse> {
    private final RekognitionClient client;
    private final ListDatasetLabelsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDatasetLabelsIterable(RekognitionClient client, ListDatasetLabelsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListDatasetLabelsResponseFetcher();
    }

    public Iterator<ListDatasetLabelsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DatasetLabelDescription> datasetLabelDescriptions() {
        Function<ListDatasetLabelsResponse, Iterator> getIterator = response -> {
            if (response != null && response.datasetLabelDescriptions() != null) {
                return response.datasetLabelDescriptions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListDatasetLabelsResponseFetcher
    implements SyncPageFetcher<ListDatasetLabelsResponse> {
        private ListDatasetLabelsResponseFetcher() {
        }

        public boolean hasNextPage(ListDatasetLabelsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListDatasetLabelsResponse nextPage(ListDatasetLabelsResponse previousPage) {
            if (previousPage == null) {
                return ListDatasetLabelsIterable.this.client.listDatasetLabels(ListDatasetLabelsIterable.this.firstRequest);
            }
            return ListDatasetLabelsIterable.this.client.listDatasetLabels((ListDatasetLabelsRequest)((Object)ListDatasetLabelsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

