/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.rekognition.RekognitionAsyncClient;
import software.amazon.awssdk.services.rekognition.internal.UserAgentUtils;
import software.amazon.awssdk.services.rekognition.model.GetFaceDetectionRequest;
import software.amazon.awssdk.services.rekognition.model.GetFaceDetectionResponse;

public class GetFaceDetectionPublisher
implements SdkPublisher<GetFaceDetectionResponse> {
    private final RekognitionAsyncClient client;
    private final GetFaceDetectionRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetFaceDetectionPublisher(RekognitionAsyncClient client, GetFaceDetectionRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetFaceDetectionPublisher(RekognitionAsyncClient client, GetFaceDetectionRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetFaceDetectionResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetFaceDetectionResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class GetFaceDetectionResponseFetcher
    implements AsyncPageFetcher<GetFaceDetectionResponse> {
        private GetFaceDetectionResponseFetcher() {
        }

        public boolean hasNextPage(GetFaceDetectionResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetFaceDetectionResponse> nextPage(GetFaceDetectionResponse previousPage) {
            if (previousPage == null) {
                return GetFaceDetectionPublisher.this.client.getFaceDetection(GetFaceDetectionPublisher.this.firstRequest);
            }
            return GetFaceDetectionPublisher.this.client.getFaceDetection((GetFaceDetectionRequest)((Object)GetFaceDetectionPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

