/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ProjectVersionStatus {
    TRAINING_IN_PROGRESS("TRAINING_IN_PROGRESS"),
    TRAINING_COMPLETED("TRAINING_COMPLETED"),
    TRAINING_FAILED("TRAINING_FAILED"),
    STARTING("STARTING"),
    RUNNING("RUNNING"),
    FAILED("FAILED"),
    STOPPING("STOPPING"),
    STOPPED("STOPPED"),
    DELETING("DELETING"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ProjectVersionStatus> VALUE_MAP;
    private final String value;

    private ProjectVersionStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ProjectVersionStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ProjectVersionStatus> knownValues() {
        EnumSet<ProjectVersionStatus> knownValues = EnumSet.allOf(ProjectVersionStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ProjectVersionStatus.class, ProjectVersionStatus::toString);
    }
}

