/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.rekognition.model.Image;
import software.amazon.awssdk.services.rekognition.model.QualityFilter;
import software.amazon.awssdk.services.rekognition.model.RekognitionRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchFacesByImageRequest
extends RekognitionRequest
implements ToCopyableBuilder<Builder, SearchFacesByImageRequest> {
    private static final SdkField<String> COLLECTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CollectionId").getter(SearchFacesByImageRequest.getter(SearchFacesByImageRequest::collectionId)).setter(SearchFacesByImageRequest.setter(Builder::collectionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CollectionId").build()}).build();
    private static final SdkField<Image> IMAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Image").getter(SearchFacesByImageRequest.getter(SearchFacesByImageRequest::image)).setter(SearchFacesByImageRequest.setter(Builder::image)).constructor(Image::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Image").build()}).build();
    private static final SdkField<Integer> MAX_FACES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxFaces").getter(SearchFacesByImageRequest.getter(SearchFacesByImageRequest::maxFaces)).setter(SearchFacesByImageRequest.setter(Builder::maxFaces)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxFaces").build()}).build();
    private static final SdkField<Float> FACE_MATCH_THRESHOLD_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("FaceMatchThreshold").getter(SearchFacesByImageRequest.getter(SearchFacesByImageRequest::faceMatchThreshold)).setter(SearchFacesByImageRequest.setter(Builder::faceMatchThreshold)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FaceMatchThreshold").build()}).build();
    private static final SdkField<String> QUALITY_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QualityFilter").getter(SearchFacesByImageRequest.getter(SearchFacesByImageRequest::qualityFilterAsString)).setter(SearchFacesByImageRequest.setter(Builder::qualityFilter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QualityFilter").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLLECTION_ID_FIELD, IMAGE_FIELD, MAX_FACES_FIELD, FACE_MATCH_THRESHOLD_FIELD, QUALITY_FILTER_FIELD));
    private final String collectionId;
    private final Image image;
    private final Integer maxFaces;
    private final Float faceMatchThreshold;
    private final String qualityFilter;

    private SearchFacesByImageRequest(BuilderImpl builder) {
        super(builder);
        this.collectionId = builder.collectionId;
        this.image = builder.image;
        this.maxFaces = builder.maxFaces;
        this.faceMatchThreshold = builder.faceMatchThreshold;
        this.qualityFilter = builder.qualityFilter;
    }

    public final String collectionId() {
        return this.collectionId;
    }

    public final Image image() {
        return this.image;
    }

    public final Integer maxFaces() {
        return this.maxFaces;
    }

    public final Float faceMatchThreshold() {
        return this.faceMatchThreshold;
    }

    public final QualityFilter qualityFilter() {
        return QualityFilter.fromValue(this.qualityFilter);
    }

    public final String qualityFilterAsString() {
        return this.qualityFilter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.collectionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.image());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxFaces());
        hashCode = 31 * hashCode + Objects.hashCode(this.faceMatchThreshold());
        hashCode = 31 * hashCode + Objects.hashCode(this.qualityFilterAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchFacesByImageRequest)) {
            return false;
        }
        SearchFacesByImageRequest other = (SearchFacesByImageRequest)((Object)obj);
        return Objects.equals(this.collectionId(), other.collectionId()) && Objects.equals(this.image(), other.image()) && Objects.equals(this.maxFaces(), other.maxFaces()) && Objects.equals(this.faceMatchThreshold(), other.faceMatchThreshold()) && Objects.equals(this.qualityFilterAsString(), other.qualityFilterAsString());
    }

    public final String toString() {
        return ToString.builder((String)"SearchFacesByImageRequest").add("CollectionId", (Object)this.collectionId()).add("Image", (Object)this.image()).add("MaxFaces", (Object)this.maxFaces()).add("FaceMatchThreshold", (Object)this.faceMatchThreshold()).add("QualityFilter", (Object)this.qualityFilterAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CollectionId": {
                return Optional.ofNullable(clazz.cast(this.collectionId()));
            }
            case "Image": {
                return Optional.ofNullable(clazz.cast(this.image()));
            }
            case "MaxFaces": {
                return Optional.ofNullable(clazz.cast(this.maxFaces()));
            }
            case "FaceMatchThreshold": {
                return Optional.ofNullable(clazz.cast(this.faceMatchThreshold()));
            }
            case "QualityFilter": {
                return Optional.ofNullable(clazz.cast(this.qualityFilterAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchFacesByImageRequest, T> g) {
        return obj -> g.apply((SearchFacesByImageRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RekognitionRequest.BuilderImpl
    implements Builder {
        private String collectionId;
        private Image image;
        private Integer maxFaces;
        private Float faceMatchThreshold;
        private String qualityFilter;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchFacesByImageRequest model) {
            super(model);
            this.collectionId(model.collectionId);
            this.image(model.image);
            this.maxFaces(model.maxFaces);
            this.faceMatchThreshold(model.faceMatchThreshold);
            this.qualityFilter(model.qualityFilter);
        }

        public final String getCollectionId() {
            return this.collectionId;
        }

        public final void setCollectionId(String collectionId) {
            this.collectionId = collectionId;
        }

        @Override
        @Transient
        public final Builder collectionId(String collectionId) {
            this.collectionId = collectionId;
            return this;
        }

        public final Image.Builder getImage() {
            return this.image != null ? this.image.toBuilder() : null;
        }

        public final void setImage(Image.BuilderImpl image) {
            this.image = image != null ? image.build() : null;
        }

        @Override
        @Transient
        public final Builder image(Image image) {
            this.image = image;
            return this;
        }

        public final Integer getMaxFaces() {
            return this.maxFaces;
        }

        public final void setMaxFaces(Integer maxFaces) {
            this.maxFaces = maxFaces;
        }

        @Override
        @Transient
        public final Builder maxFaces(Integer maxFaces) {
            this.maxFaces = maxFaces;
            return this;
        }

        public final Float getFaceMatchThreshold() {
            return this.faceMatchThreshold;
        }

        public final void setFaceMatchThreshold(Float faceMatchThreshold) {
            this.faceMatchThreshold = faceMatchThreshold;
        }

        @Override
        @Transient
        public final Builder faceMatchThreshold(Float faceMatchThreshold) {
            this.faceMatchThreshold = faceMatchThreshold;
            return this;
        }

        public final String getQualityFilter() {
            return this.qualityFilter;
        }

        public final void setQualityFilter(String qualityFilter) {
            this.qualityFilter = qualityFilter;
        }

        @Override
        @Transient
        public final Builder qualityFilter(String qualityFilter) {
            this.qualityFilter = qualityFilter;
            return this;
        }

        @Override
        @Transient
        public final Builder qualityFilter(QualityFilter qualityFilter) {
            this.qualityFilter(qualityFilter == null ? null : qualityFilter.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SearchFacesByImageRequest build() {
            return new SearchFacesByImageRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RekognitionRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SearchFacesByImageRequest> {
        public Builder collectionId(String var1);

        public Builder image(Image var1);

        default public Builder image(Consumer<Image.Builder> image) {
            return this.image((Image)((Image.Builder)Image.builder().applyMutation(image)).build());
        }

        public Builder maxFaces(Integer var1);

        public Builder faceMatchThreshold(Float var1);

        public Builder qualityFilter(String var1);

        public Builder qualityFilter(QualityFilter var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

