/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.rekognition.model.DatasetStats;
import software.amazon.awssdk.services.rekognition.model.DatasetStatus;
import software.amazon.awssdk.services.rekognition.model.DatasetStatusMessageCode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DatasetDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DatasetDescription> {
    private static final SdkField<Instant> CREATION_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTimestamp").getter(DatasetDescription.getter(DatasetDescription::creationTimestamp)).setter(DatasetDescription.setter(Builder::creationTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTimestamp").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdatedTimestamp").getter(DatasetDescription.getter(DatasetDescription::lastUpdatedTimestamp)).setter(DatasetDescription.setter(Builder::lastUpdatedTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTimestamp").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(DatasetDescription.getter(DatasetDescription::statusAsString)).setter(DatasetDescription.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusMessage").getter(DatasetDescription.getter(DatasetDescription::statusMessage)).setter(DatasetDescription.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusMessageCode").getter(DatasetDescription.getter(DatasetDescription::statusMessageCodeAsString)).setter(DatasetDescription.setter(Builder::statusMessageCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessageCode").build()}).build();
    private static final SdkField<DatasetStats> DATASET_STATS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DatasetStats").getter(DatasetDescription.getter(DatasetDescription::datasetStats)).setter(DatasetDescription.setter(Builder::datasetStats)).constructor(DatasetStats::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetStats").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATION_TIMESTAMP_FIELD, LAST_UPDATED_TIMESTAMP_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD, STATUS_MESSAGE_CODE_FIELD, DATASET_STATS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Instant creationTimestamp;
    private final Instant lastUpdatedTimestamp;
    private final String status;
    private final String statusMessage;
    private final String statusMessageCode;
    private final DatasetStats datasetStats;

    private DatasetDescription(BuilderImpl builder) {
        this.creationTimestamp = builder.creationTimestamp;
        this.lastUpdatedTimestamp = builder.lastUpdatedTimestamp;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.statusMessageCode = builder.statusMessageCode;
        this.datasetStats = builder.datasetStats;
    }

    public final Instant creationTimestamp() {
        return this.creationTimestamp;
    }

    public final Instant lastUpdatedTimestamp() {
        return this.lastUpdatedTimestamp;
    }

    public final DatasetStatus status() {
        return DatasetStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public final DatasetStatusMessageCode statusMessageCode() {
        return DatasetStatusMessageCode.fromValue(this.statusMessageCode);
    }

    public final String statusMessageCodeAsString() {
        return this.statusMessageCode;
    }

    public final DatasetStats datasetStats() {
        return this.datasetStats;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessageCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetStats());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatasetDescription)) {
            return false;
        }
        DatasetDescription other = (DatasetDescription)obj;
        return Objects.equals(this.creationTimestamp(), other.creationTimestamp()) && Objects.equals(this.lastUpdatedTimestamp(), other.lastUpdatedTimestamp()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusMessage(), other.statusMessage()) && Objects.equals(this.statusMessageCodeAsString(), other.statusMessageCodeAsString()) && Objects.equals(this.datasetStats(), other.datasetStats());
    }

    public final String toString() {
        return ToString.builder((String)"DatasetDescription").add("CreationTimestamp", (Object)this.creationTimestamp()).add("LastUpdatedTimestamp", (Object)this.lastUpdatedTimestamp()).add("Status", (Object)this.statusAsString()).add("StatusMessage", (Object)this.statusMessage()).add("StatusMessageCode", (Object)this.statusMessageCodeAsString()).add("DatasetStats", (Object)this.datasetStats()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CreationTimestamp": {
                return Optional.ofNullable(clazz.cast(this.creationTimestamp()));
            }
            case "LastUpdatedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTimestamp()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StatusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
            case "StatusMessageCode": {
                return Optional.ofNullable(clazz.cast(this.statusMessageCodeAsString()));
            }
            case "DatasetStats": {
                return Optional.ofNullable(clazz.cast(this.datasetStats()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DatasetDescription, T> g) {
        return obj -> g.apply((DatasetDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant creationTimestamp;
        private Instant lastUpdatedTimestamp;
        private String status;
        private String statusMessage;
        private String statusMessageCode;
        private DatasetStats datasetStats;

        private BuilderImpl() {
        }

        private BuilderImpl(DatasetDescription model) {
            this.creationTimestamp(model.creationTimestamp);
            this.lastUpdatedTimestamp(model.lastUpdatedTimestamp);
            this.status(model.status);
            this.statusMessage(model.statusMessage);
            this.statusMessageCode(model.statusMessageCode);
            this.datasetStats(model.datasetStats);
        }

        public final Instant getCreationTimestamp() {
            return this.creationTimestamp;
        }

        public final void setCreationTimestamp(Instant creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
        }

        @Override
        @Transient
        public final Builder creationTimestamp(Instant creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
            return this;
        }

        public final Instant getLastUpdatedTimestamp() {
            return this.lastUpdatedTimestamp;
        }

        public final void setLastUpdatedTimestamp(Instant lastUpdatedTimestamp) {
            this.lastUpdatedTimestamp = lastUpdatedTimestamp;
        }

        @Override
        @Transient
        public final Builder lastUpdatedTimestamp(Instant lastUpdatedTimestamp) {
            this.lastUpdatedTimestamp = lastUpdatedTimestamp;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(DatasetStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        @Transient
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final String getStatusMessageCode() {
            return this.statusMessageCode;
        }

        public final void setStatusMessageCode(String statusMessageCode) {
            this.statusMessageCode = statusMessageCode;
        }

        @Override
        @Transient
        public final Builder statusMessageCode(String statusMessageCode) {
            this.statusMessageCode = statusMessageCode;
            return this;
        }

        @Override
        @Transient
        public final Builder statusMessageCode(DatasetStatusMessageCode statusMessageCode) {
            this.statusMessageCode(statusMessageCode == null ? null : statusMessageCode.toString());
            return this;
        }

        public final DatasetStats.Builder getDatasetStats() {
            return this.datasetStats != null ? this.datasetStats.toBuilder() : null;
        }

        public final void setDatasetStats(DatasetStats.BuilderImpl datasetStats) {
            this.datasetStats = datasetStats != null ? datasetStats.build() : null;
        }

        @Override
        @Transient
        public final Builder datasetStats(DatasetStats datasetStats) {
            this.datasetStats = datasetStats;
            return this;
        }

        public DatasetDescription build() {
            return new DatasetDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DatasetDescription> {
        public Builder creationTimestamp(Instant var1);

        public Builder lastUpdatedTimestamp(Instant var1);

        public Builder status(String var1);

        public Builder status(DatasetStatus var1);

        public Builder statusMessage(String var1);

        public Builder statusMessageCode(String var1);

        public Builder statusMessageCode(DatasetStatusMessageCode var1);

        public Builder datasetStats(DatasetStats var1);

        default public Builder datasetStats(Consumer<DatasetStats.Builder> datasetStats) {
            return this.datasetStats((DatasetStats)((DatasetStats.Builder)DatasetStats.builder().applyMutation(datasetStats)).build());
        }
    }
}

