/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rekognition.model.BodyPart;
import software.amazon.awssdk.services.rekognition.model.EquipmentDetection;
import software.amazon.awssdk.services.rekognition.model.EquipmentDetectionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProtectiveEquipmentBodyPart
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProtectiveEquipmentBodyPart> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(ProtectiveEquipmentBodyPart.getter(ProtectiveEquipmentBodyPart::nameAsString)).setter(ProtectiveEquipmentBodyPart.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<Float> CONFIDENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("Confidence").getter(ProtectiveEquipmentBodyPart.getter(ProtectiveEquipmentBodyPart::confidence)).setter(ProtectiveEquipmentBodyPart.setter(Builder::confidence)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Confidence").build()}).build();
    private static final SdkField<List<EquipmentDetection>> EQUIPMENT_DETECTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EquipmentDetections").getter(ProtectiveEquipmentBodyPart.getter(ProtectiveEquipmentBodyPart::equipmentDetections)).setter(ProtectiveEquipmentBodyPart.setter(Builder::equipmentDetections)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EquipmentDetections").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EquipmentDetection::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, CONFIDENCE_FIELD, EQUIPMENT_DETECTIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final Float confidence;
    private final List<EquipmentDetection> equipmentDetections;

    private ProtectiveEquipmentBodyPart(BuilderImpl builder) {
        this.name = builder.name;
        this.confidence = builder.confidence;
        this.equipmentDetections = builder.equipmentDetections;
    }

    public BodyPart name() {
        return BodyPart.fromValue(this.name);
    }

    public String nameAsString() {
        return this.name;
    }

    public Float confidence() {
        return this.confidence;
    }

    public boolean hasEquipmentDetections() {
        return this.equipmentDetections != null && !(this.equipmentDetections instanceof SdkAutoConstructList);
    }

    public List<EquipmentDetection> equipmentDetections() {
        return this.equipmentDetections;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.nameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.confidence());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEquipmentDetections() ? this.equipmentDetections() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProtectiveEquipmentBodyPart)) {
            return false;
        }
        ProtectiveEquipmentBodyPart other = (ProtectiveEquipmentBodyPart)obj;
        return Objects.equals(this.nameAsString(), other.nameAsString()) && Objects.equals(this.confidence(), other.confidence()) && this.hasEquipmentDetections() == other.hasEquipmentDetections() && Objects.equals(this.equipmentDetections(), other.equipmentDetections());
    }

    public String toString() {
        return ToString.builder((String)"ProtectiveEquipmentBodyPart").add("Name", (Object)this.nameAsString()).add("Confidence", (Object)this.confidence()).add("EquipmentDetections", this.hasEquipmentDetections() ? this.equipmentDetections() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.nameAsString()));
            }
            case "Confidence": {
                return Optional.ofNullable(clazz.cast(this.confidence()));
            }
            case "EquipmentDetections": {
                return Optional.ofNullable(clazz.cast(this.equipmentDetections()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProtectiveEquipmentBodyPart, T> g) {
        return obj -> g.apply((ProtectiveEquipmentBodyPart)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private Float confidence;
        private List<EquipmentDetection> equipmentDetections = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ProtectiveEquipmentBodyPart model) {
            this.name(model.name);
            this.confidence(model.confidence);
            this.equipmentDetections(model.equipmentDetections);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public final Builder name(BodyPart name) {
            this.name(name == null ? null : name.toString());
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Float getConfidence() {
            return this.confidence;
        }

        @Override
        public final Builder confidence(Float confidence) {
            this.confidence = confidence;
            return this;
        }

        public final void setConfidence(Float confidence) {
            this.confidence = confidence;
        }

        public final Collection<EquipmentDetection.Builder> getEquipmentDetections() {
            if (this.equipmentDetections instanceof SdkAutoConstructList) {
                return null;
            }
            return this.equipmentDetections != null ? (Collection)this.equipmentDetections.stream().map(EquipmentDetection::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder equipmentDetections(Collection<EquipmentDetection> equipmentDetections) {
            this.equipmentDetections = EquipmentDetectionsCopier.copy(equipmentDetections);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder equipmentDetections(EquipmentDetection ... equipmentDetections) {
            this.equipmentDetections(Arrays.asList(equipmentDetections));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder equipmentDetections(Consumer<EquipmentDetection.Builder> ... equipmentDetections) {
            this.equipmentDetections(Stream.of(equipmentDetections).map(c -> (EquipmentDetection)((EquipmentDetection.Builder)EquipmentDetection.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEquipmentDetections(Collection<EquipmentDetection.BuilderImpl> equipmentDetections) {
            this.equipmentDetections = EquipmentDetectionsCopier.copyFromBuilder(equipmentDetections);
        }

        public ProtectiveEquipmentBodyPart build() {
            return new ProtectiveEquipmentBodyPart(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProtectiveEquipmentBodyPart> {
        public Builder name(String var1);

        public Builder name(BodyPart var1);

        public Builder confidence(Float var1);

        public Builder equipmentDetections(Collection<EquipmentDetection> var1);

        public Builder equipmentDetections(EquipmentDetection ... var1);

        public Builder equipmentDetections(Consumer<EquipmentDetection.Builder> ... var1);
    }
}

