/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rekognition.model.ProtectiveEquipmentType;
import software.amazon.awssdk.services.rekognition.model.ProtectiveEquipmentTypesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProtectiveEquipmentSummarizationAttributes
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProtectiveEquipmentSummarizationAttributes> {
    private static final SdkField<Float> MIN_CONFIDENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("MinConfidence").getter(ProtectiveEquipmentSummarizationAttributes.getter(ProtectiveEquipmentSummarizationAttributes::minConfidence)).setter(ProtectiveEquipmentSummarizationAttributes.setter(Builder::minConfidence)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinConfidence").build()}).build();
    private static final SdkField<List<String>> REQUIRED_EQUIPMENT_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RequiredEquipmentTypes").getter(ProtectiveEquipmentSummarizationAttributes.getter(ProtectiveEquipmentSummarizationAttributes::requiredEquipmentTypesAsStrings)).setter(ProtectiveEquipmentSummarizationAttributes.setter(Builder::requiredEquipmentTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequiredEquipmentTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MIN_CONFIDENCE_FIELD, REQUIRED_EQUIPMENT_TYPES_FIELD));
    private static final long serialVersionUID = 1L;
    private final Float minConfidence;
    private final List<String> requiredEquipmentTypes;

    private ProtectiveEquipmentSummarizationAttributes(BuilderImpl builder) {
        this.minConfidence = builder.minConfidence;
        this.requiredEquipmentTypes = builder.requiredEquipmentTypes;
    }

    public Float minConfidence() {
        return this.minConfidence;
    }

    public List<ProtectiveEquipmentType> requiredEquipmentTypes() {
        return ProtectiveEquipmentTypesCopier.copyStringToEnum(this.requiredEquipmentTypes);
    }

    public boolean hasRequiredEquipmentTypes() {
        return this.requiredEquipmentTypes != null && !(this.requiredEquipmentTypes instanceof SdkAutoConstructList);
    }

    public List<String> requiredEquipmentTypesAsStrings() {
        return this.requiredEquipmentTypes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.minConfidence());
        hashCode = 31 * hashCode + Objects.hashCode(this.requiredEquipmentTypesAsStrings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProtectiveEquipmentSummarizationAttributes)) {
            return false;
        }
        ProtectiveEquipmentSummarizationAttributes other = (ProtectiveEquipmentSummarizationAttributes)obj;
        return Objects.equals(this.minConfidence(), other.minConfidence()) && Objects.equals(this.requiredEquipmentTypesAsStrings(), other.requiredEquipmentTypesAsStrings());
    }

    public String toString() {
        return ToString.builder((String)"ProtectiveEquipmentSummarizationAttributes").add("MinConfidence", (Object)this.minConfidence()).add("RequiredEquipmentTypes", this.requiredEquipmentTypesAsStrings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MinConfidence": {
                return Optional.ofNullable(clazz.cast(this.minConfidence()));
            }
            case "RequiredEquipmentTypes": {
                return Optional.ofNullable(clazz.cast(this.requiredEquipmentTypesAsStrings()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProtectiveEquipmentSummarizationAttributes, T> g) {
        return obj -> g.apply((ProtectiveEquipmentSummarizationAttributes)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Float minConfidence;
        private List<String> requiredEquipmentTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ProtectiveEquipmentSummarizationAttributes model) {
            this.minConfidence(model.minConfidence);
            this.requiredEquipmentTypesWithStrings(model.requiredEquipmentTypes);
        }

        public final Float getMinConfidence() {
            return this.minConfidence;
        }

        @Override
        public final Builder minConfidence(Float minConfidence) {
            this.minConfidence = minConfidence;
            return this;
        }

        public final void setMinConfidence(Float minConfidence) {
            this.minConfidence = minConfidence;
        }

        public final Collection<String> getRequiredEquipmentTypes() {
            return this.requiredEquipmentTypes;
        }

        @Override
        public final Builder requiredEquipmentTypesWithStrings(Collection<String> requiredEquipmentTypes) {
            this.requiredEquipmentTypes = ProtectiveEquipmentTypesCopier.copy(requiredEquipmentTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder requiredEquipmentTypesWithStrings(String ... requiredEquipmentTypes) {
            this.requiredEquipmentTypesWithStrings(Arrays.asList(requiredEquipmentTypes));
            return this;
        }

        @Override
        public final Builder requiredEquipmentTypes(Collection<ProtectiveEquipmentType> requiredEquipmentTypes) {
            this.requiredEquipmentTypes = ProtectiveEquipmentTypesCopier.copyEnumToString(requiredEquipmentTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder requiredEquipmentTypes(ProtectiveEquipmentType ... requiredEquipmentTypes) {
            this.requiredEquipmentTypes(Arrays.asList(requiredEquipmentTypes));
            return this;
        }

        public final void setRequiredEquipmentTypes(Collection<String> requiredEquipmentTypes) {
            this.requiredEquipmentTypes = ProtectiveEquipmentTypesCopier.copy(requiredEquipmentTypes);
        }

        public ProtectiveEquipmentSummarizationAttributes build() {
            return new ProtectiveEquipmentSummarizationAttributes(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProtectiveEquipmentSummarizationAttributes> {
        public Builder minConfidence(Float var1);

        public Builder requiredEquipmentTypesWithStrings(Collection<String> var1);

        public Builder requiredEquipmentTypesWithStrings(String ... var1);

        public Builder requiredEquipmentTypes(Collection<ProtectiveEquipmentType> var1);

        public Builder requiredEquipmentTypes(ProtectiveEquipmentType ... var1);
    }
}

