/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rekognition.model.FaceDetail;
import software.amazon.awssdk.services.rekognition.model.FaceDetailListCopier;
import software.amazon.awssdk.services.rekognition.model.OrientationCorrection;
import software.amazon.awssdk.services.rekognition.model.RekognitionResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DetectFacesResponse
extends RekognitionResponse
implements ToCopyableBuilder<Builder, DetectFacesResponse> {
    private static final SdkField<List<FaceDetail>> FACE_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FaceDetails").getter(DetectFacesResponse.getter(DetectFacesResponse::faceDetails)).setter(DetectFacesResponse.setter(Builder::faceDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FaceDetails").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FaceDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ORIENTATION_CORRECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OrientationCorrection").getter(DetectFacesResponse.getter(DetectFacesResponse::orientationCorrectionAsString)).setter(DetectFacesResponse.setter(Builder::orientationCorrection)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrientationCorrection").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FACE_DETAILS_FIELD, ORIENTATION_CORRECTION_FIELD));
    private final List<FaceDetail> faceDetails;
    private final String orientationCorrection;

    private DetectFacesResponse(BuilderImpl builder) {
        super(builder);
        this.faceDetails = builder.faceDetails;
        this.orientationCorrection = builder.orientationCorrection;
    }

    public boolean hasFaceDetails() {
        return this.faceDetails != null && !(this.faceDetails instanceof SdkAutoConstructList);
    }

    public List<FaceDetail> faceDetails() {
        return this.faceDetails;
    }

    public OrientationCorrection orientationCorrection() {
        return OrientationCorrection.fromValue(this.orientationCorrection);
    }

    public String orientationCorrectionAsString() {
        return this.orientationCorrection;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.faceDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.orientationCorrectionAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectFacesResponse)) {
            return false;
        }
        DetectFacesResponse other = (DetectFacesResponse)((Object)obj);
        return Objects.equals(this.faceDetails(), other.faceDetails()) && Objects.equals(this.orientationCorrectionAsString(), other.orientationCorrectionAsString());
    }

    public String toString() {
        return ToString.builder((String)"DetectFacesResponse").add("FaceDetails", this.faceDetails()).add("OrientationCorrection", (Object)this.orientationCorrectionAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FaceDetails": {
                return Optional.ofNullable(clazz.cast(this.faceDetails()));
            }
            case "OrientationCorrection": {
                return Optional.ofNullable(clazz.cast(this.orientationCorrectionAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DetectFacesResponse, T> g) {
        return obj -> g.apply((DetectFacesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RekognitionResponse.BuilderImpl
    implements Builder {
        private List<FaceDetail> faceDetails = DefaultSdkAutoConstructList.getInstance();
        private String orientationCorrection;

        private BuilderImpl() {
        }

        private BuilderImpl(DetectFacesResponse model) {
            super(model);
            this.faceDetails(model.faceDetails);
            this.orientationCorrection(model.orientationCorrection);
        }

        public final Collection<FaceDetail.Builder> getFaceDetails() {
            return this.faceDetails != null ? (Collection)this.faceDetails.stream().map(FaceDetail::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder faceDetails(Collection<FaceDetail> faceDetails) {
            this.faceDetails = FaceDetailListCopier.copy(faceDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder faceDetails(FaceDetail ... faceDetails) {
            this.faceDetails(Arrays.asList(faceDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder faceDetails(Consumer<FaceDetail.Builder> ... faceDetails) {
            this.faceDetails(Stream.of(faceDetails).map(c -> (FaceDetail)((FaceDetail.Builder)FaceDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFaceDetails(Collection<FaceDetail.BuilderImpl> faceDetails) {
            this.faceDetails = FaceDetailListCopier.copyFromBuilder(faceDetails);
        }

        public final String getOrientationCorrection() {
            return this.orientationCorrection;
        }

        @Override
        public final Builder orientationCorrection(String orientationCorrection) {
            this.orientationCorrection = orientationCorrection;
            return this;
        }

        @Override
        public final Builder orientationCorrection(OrientationCorrection orientationCorrection) {
            this.orientationCorrection(orientationCorrection == null ? null : orientationCorrection.toString());
            return this;
        }

        public final void setOrientationCorrection(String orientationCorrection) {
            this.orientationCorrection = orientationCorrection;
        }

        @Override
        public DetectFacesResponse build() {
            return new DetectFacesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RekognitionResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DetectFacesResponse> {
        public Builder faceDetails(Collection<FaceDetail> var1);

        public Builder faceDetails(FaceDetail ... var1);

        public Builder faceDetails(Consumer<FaceDetail.Builder> ... var1);

        public Builder orientationCorrection(String var1);

        public Builder orientationCorrection(OrientationCorrection var1);
    }
}

