/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rekognition.model.DetectionFilter;
import software.amazon.awssdk.services.rekognition.model.RegionOfInterest;
import software.amazon.awssdk.services.rekognition.model.RegionsOfInterestCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartTextDetectionFilters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StartTextDetectionFilters> {
    private static final SdkField<DetectionFilter> WORD_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("WordFilter").getter(StartTextDetectionFilters.getter(StartTextDetectionFilters::wordFilter)).setter(StartTextDetectionFilters.setter(Builder::wordFilter)).constructor(DetectionFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WordFilter").build()}).build();
    private static final SdkField<List<RegionOfInterest>> REGIONS_OF_INTEREST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RegionsOfInterest").getter(StartTextDetectionFilters.getter(StartTextDetectionFilters::regionsOfInterest)).setter(StartTextDetectionFilters.setter(Builder::regionsOfInterest)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegionsOfInterest").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RegionOfInterest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORD_FILTER_FIELD, REGIONS_OF_INTEREST_FIELD));
    private static final long serialVersionUID = 1L;
    private final DetectionFilter wordFilter;
    private final List<RegionOfInterest> regionsOfInterest;

    private StartTextDetectionFilters(BuilderImpl builder) {
        this.wordFilter = builder.wordFilter;
        this.regionsOfInterest = builder.regionsOfInterest;
    }

    public DetectionFilter wordFilter() {
        return this.wordFilter;
    }

    public boolean hasRegionsOfInterest() {
        return this.regionsOfInterest != null && !(this.regionsOfInterest instanceof SdkAutoConstructList);
    }

    public List<RegionOfInterest> regionsOfInterest() {
        return this.regionsOfInterest;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.wordFilter());
        hashCode = 31 * hashCode + Objects.hashCode(this.regionsOfInterest());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartTextDetectionFilters)) {
            return false;
        }
        StartTextDetectionFilters other = (StartTextDetectionFilters)obj;
        return Objects.equals(this.wordFilter(), other.wordFilter()) && Objects.equals(this.regionsOfInterest(), other.regionsOfInterest());
    }

    public String toString() {
        return ToString.builder((String)"StartTextDetectionFilters").add("WordFilter", (Object)this.wordFilter()).add("RegionsOfInterest", this.regionsOfInterest()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WordFilter": {
                return Optional.ofNullable(clazz.cast(this.wordFilter()));
            }
            case "RegionsOfInterest": {
                return Optional.ofNullable(clazz.cast(this.regionsOfInterest()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartTextDetectionFilters, T> g) {
        return obj -> g.apply((StartTextDetectionFilters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private DetectionFilter wordFilter;
        private List<RegionOfInterest> regionsOfInterest = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartTextDetectionFilters model) {
            this.wordFilter(model.wordFilter);
            this.regionsOfInterest(model.regionsOfInterest);
        }

        public final DetectionFilter.Builder getWordFilter() {
            return this.wordFilter != null ? this.wordFilter.toBuilder() : null;
        }

        @Override
        public final Builder wordFilter(DetectionFilter wordFilter) {
            this.wordFilter = wordFilter;
            return this;
        }

        public final void setWordFilter(DetectionFilter.BuilderImpl wordFilter) {
            this.wordFilter = wordFilter != null ? wordFilter.build() : null;
        }

        public final Collection<RegionOfInterest.Builder> getRegionsOfInterest() {
            return this.regionsOfInterest != null ? (Collection)this.regionsOfInterest.stream().map(RegionOfInterest::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder regionsOfInterest(Collection<RegionOfInterest> regionsOfInterest) {
            this.regionsOfInterest = RegionsOfInterestCopier.copy(regionsOfInterest);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regionsOfInterest(RegionOfInterest ... regionsOfInterest) {
            this.regionsOfInterest(Arrays.asList(regionsOfInterest));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regionsOfInterest(Consumer<RegionOfInterest.Builder> ... regionsOfInterest) {
            this.regionsOfInterest(Stream.of(regionsOfInterest).map(c -> (RegionOfInterest)((RegionOfInterest.Builder)RegionOfInterest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRegionsOfInterest(Collection<RegionOfInterest.BuilderImpl> regionsOfInterest) {
            this.regionsOfInterest = RegionsOfInterestCopier.copyFromBuilder(regionsOfInterest);
        }

        public StartTextDetectionFilters build() {
            return new StartTextDetectionFilters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StartTextDetectionFilters> {
        public Builder wordFilter(DetectionFilter var1);

        default public Builder wordFilter(Consumer<DetectionFilter.Builder> wordFilter) {
            return this.wordFilter((DetectionFilter)((DetectionFilter.Builder)DetectionFilter.builder().applyMutation(wordFilter)).build());
        }

        public Builder regionsOfInterest(Collection<RegionOfInterest> var1);

        public Builder regionsOfInterest(RegionOfInterest ... var1);

        public Builder regionsOfInterest(Consumer<RegionOfInterest.Builder> ... var1);
    }
}

