/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.rekognition.model.Image;
import software.amazon.awssdk.services.rekognition.model.RekognitionRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchFacesByImageRequest
extends RekognitionRequest
implements ToCopyableBuilder<Builder, SearchFacesByImageRequest> {
    private static final SdkField<String> COLLECTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SearchFacesByImageRequest.getter(SearchFacesByImageRequest::collectionId)).setter(SearchFacesByImageRequest.setter(Builder::collectionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CollectionId").build()}).build();
    private static final SdkField<Image> IMAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(SearchFacesByImageRequest.getter(SearchFacesByImageRequest::image)).setter(SearchFacesByImageRequest.setter(Builder::image)).constructor(Image::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Image").build()}).build();
    private static final SdkField<Integer> MAX_FACES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(SearchFacesByImageRequest.getter(SearchFacesByImageRequest::maxFaces)).setter(SearchFacesByImageRequest.setter(Builder::maxFaces)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxFaces").build()}).build();
    private static final SdkField<Float> FACE_MATCH_THRESHOLD_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).getter(SearchFacesByImageRequest.getter(SearchFacesByImageRequest::faceMatchThreshold)).setter(SearchFacesByImageRequest.setter(Builder::faceMatchThreshold)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FaceMatchThreshold").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLLECTION_ID_FIELD, IMAGE_FIELD, MAX_FACES_FIELD, FACE_MATCH_THRESHOLD_FIELD));
    private final String collectionId;
    private final Image image;
    private final Integer maxFaces;
    private final Float faceMatchThreshold;

    private SearchFacesByImageRequest(BuilderImpl builder) {
        super(builder);
        this.collectionId = builder.collectionId;
        this.image = builder.image;
        this.maxFaces = builder.maxFaces;
        this.faceMatchThreshold = builder.faceMatchThreshold;
    }

    public String collectionId() {
        return this.collectionId;
    }

    public Image image() {
        return this.image;
    }

    public Integer maxFaces() {
        return this.maxFaces;
    }

    public Float faceMatchThreshold() {
        return this.faceMatchThreshold;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.collectionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.image());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxFaces());
        hashCode = 31 * hashCode + Objects.hashCode(this.faceMatchThreshold());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchFacesByImageRequest)) {
            return false;
        }
        SearchFacesByImageRequest other = (SearchFacesByImageRequest)((Object)obj);
        return Objects.equals(this.collectionId(), other.collectionId()) && Objects.equals(this.image(), other.image()) && Objects.equals(this.maxFaces(), other.maxFaces()) && Objects.equals(this.faceMatchThreshold(), other.faceMatchThreshold());
    }

    public String toString() {
        return ToString.builder((String)"SearchFacesByImageRequest").add("CollectionId", (Object)this.collectionId()).add("Image", (Object)this.image()).add("MaxFaces", (Object)this.maxFaces()).add("FaceMatchThreshold", (Object)this.faceMatchThreshold()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CollectionId": {
                return Optional.ofNullable(clazz.cast(this.collectionId()));
            }
            case "Image": {
                return Optional.ofNullable(clazz.cast(this.image()));
            }
            case "MaxFaces": {
                return Optional.ofNullable(clazz.cast(this.maxFaces()));
            }
            case "FaceMatchThreshold": {
                return Optional.ofNullable(clazz.cast(this.faceMatchThreshold()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchFacesByImageRequest, T> g) {
        return obj -> g.apply((SearchFacesByImageRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RekognitionRequest.BuilderImpl
    implements Builder {
        private String collectionId;
        private Image image;
        private Integer maxFaces;
        private Float faceMatchThreshold;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchFacesByImageRequest model) {
            super(model);
            this.collectionId(model.collectionId);
            this.image(model.image);
            this.maxFaces(model.maxFaces);
            this.faceMatchThreshold(model.faceMatchThreshold);
        }

        public final String getCollectionId() {
            return this.collectionId;
        }

        @Override
        public final Builder collectionId(String collectionId) {
            this.collectionId = collectionId;
            return this;
        }

        public final void setCollectionId(String collectionId) {
            this.collectionId = collectionId;
        }

        public final Image.Builder getImage() {
            return this.image != null ? this.image.toBuilder() : null;
        }

        @Override
        public final Builder image(Image image) {
            this.image = image;
            return this;
        }

        public final void setImage(Image.BuilderImpl image) {
            this.image = image != null ? image.build() : null;
        }

        public final Integer getMaxFaces() {
            return this.maxFaces;
        }

        @Override
        public final Builder maxFaces(Integer maxFaces) {
            this.maxFaces = maxFaces;
            return this;
        }

        public final void setMaxFaces(Integer maxFaces) {
            this.maxFaces = maxFaces;
        }

        public final Float getFaceMatchThreshold() {
            return this.faceMatchThreshold;
        }

        @Override
        public final Builder faceMatchThreshold(Float faceMatchThreshold) {
            this.faceMatchThreshold = faceMatchThreshold;
            return this;
        }

        public final void setFaceMatchThreshold(Float faceMatchThreshold) {
            this.faceMatchThreshold = faceMatchThreshold;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SearchFacesByImageRequest build() {
            return new SearchFacesByImageRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RekognitionRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SearchFacesByImageRequest> {
        public Builder collectionId(String var1);

        public Builder image(Image var1);

        default public Builder image(Consumer<Image.Builder> image) {
            return this.image((Image)((Image.Builder)Image.builder().applyMutation(image)).build());
        }

        public Builder maxFaces(Integer var1);

        public Builder faceMatchThreshold(Float var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

