/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.rekognition.model.HumanLoopActivationOutput;
import software.amazon.awssdk.services.rekognition.model.ModerationLabel;
import software.amazon.awssdk.services.rekognition.model.ModerationLabelsCopier;
import software.amazon.awssdk.services.rekognition.model.RekognitionResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DetectModerationLabelsResponse
extends RekognitionResponse
implements ToCopyableBuilder<Builder, DetectModerationLabelsResponse> {
    private static final SdkField<List<ModerationLabel>> MODERATION_LABELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DetectModerationLabelsResponse.getter(DetectModerationLabelsResponse::moderationLabels)).setter(DetectModerationLabelsResponse.setter(Builder::moderationLabels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModerationLabels").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ModerationLabel::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> MODERATION_MODEL_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DetectModerationLabelsResponse.getter(DetectModerationLabelsResponse::moderationModelVersion)).setter(DetectModerationLabelsResponse.setter(Builder::moderationModelVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModerationModelVersion").build()}).build();
    private static final SdkField<HumanLoopActivationOutput> HUMAN_LOOP_ACTIVATION_OUTPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DetectModerationLabelsResponse.getter(DetectModerationLabelsResponse::humanLoopActivationOutput)).setter(DetectModerationLabelsResponse.setter(Builder::humanLoopActivationOutput)).constructor(HumanLoopActivationOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HumanLoopActivationOutput").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODERATION_LABELS_FIELD, MODERATION_MODEL_VERSION_FIELD, HUMAN_LOOP_ACTIVATION_OUTPUT_FIELD));
    private final List<ModerationLabel> moderationLabels;
    private final String moderationModelVersion;
    private final HumanLoopActivationOutput humanLoopActivationOutput;

    private DetectModerationLabelsResponse(BuilderImpl builder) {
        super(builder);
        this.moderationLabels = builder.moderationLabels;
        this.moderationModelVersion = builder.moderationModelVersion;
        this.humanLoopActivationOutput = builder.humanLoopActivationOutput;
    }

    public List<ModerationLabel> moderationLabels() {
        return this.moderationLabels;
    }

    public String moderationModelVersion() {
        return this.moderationModelVersion;
    }

    public HumanLoopActivationOutput humanLoopActivationOutput() {
        return this.humanLoopActivationOutput;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.moderationLabels());
        hashCode = 31 * hashCode + Objects.hashCode(this.moderationModelVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.humanLoopActivationOutput());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectModerationLabelsResponse)) {
            return false;
        }
        DetectModerationLabelsResponse other = (DetectModerationLabelsResponse)((Object)obj);
        return Objects.equals(this.moderationLabels(), other.moderationLabels()) && Objects.equals(this.moderationModelVersion(), other.moderationModelVersion()) && Objects.equals(this.humanLoopActivationOutput(), other.humanLoopActivationOutput());
    }

    public String toString() {
        return ToString.builder((String)"DetectModerationLabelsResponse").add("ModerationLabels", this.moderationLabels()).add("ModerationModelVersion", (Object)this.moderationModelVersion()).add("HumanLoopActivationOutput", (Object)this.humanLoopActivationOutput()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ModerationLabels": {
                return Optional.ofNullable(clazz.cast(this.moderationLabels()));
            }
            case "ModerationModelVersion": {
                return Optional.ofNullable(clazz.cast(this.moderationModelVersion()));
            }
            case "HumanLoopActivationOutput": {
                return Optional.ofNullable(clazz.cast(this.humanLoopActivationOutput()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DetectModerationLabelsResponse, T> g) {
        return obj -> g.apply((DetectModerationLabelsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RekognitionResponse.BuilderImpl
    implements Builder {
        private List<ModerationLabel> moderationLabels = DefaultSdkAutoConstructList.getInstance();
        private String moderationModelVersion;
        private HumanLoopActivationOutput humanLoopActivationOutput;

        private BuilderImpl() {
        }

        private BuilderImpl(DetectModerationLabelsResponse model) {
            super(model);
            this.moderationLabels(model.moderationLabels);
            this.moderationModelVersion(model.moderationModelVersion);
            this.humanLoopActivationOutput(model.humanLoopActivationOutput);
        }

        public final Collection<ModerationLabel.Builder> getModerationLabels() {
            return this.moderationLabels != null ? (Collection)this.moderationLabels.stream().map(ModerationLabel::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder moderationLabels(Collection<ModerationLabel> moderationLabels) {
            this.moderationLabels = ModerationLabelsCopier.copy(moderationLabels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder moderationLabels(ModerationLabel ... moderationLabels) {
            this.moderationLabels(Arrays.asList(moderationLabels));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder moderationLabels(Consumer<ModerationLabel.Builder> ... moderationLabels) {
            this.moderationLabels(Stream.of(moderationLabels).map(c -> (ModerationLabel)((ModerationLabel.Builder)ModerationLabel.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setModerationLabels(Collection<ModerationLabel.BuilderImpl> moderationLabels) {
            this.moderationLabels = ModerationLabelsCopier.copyFromBuilder(moderationLabels);
        }

        public final String getModerationModelVersion() {
            return this.moderationModelVersion;
        }

        @Override
        public final Builder moderationModelVersion(String moderationModelVersion) {
            this.moderationModelVersion = moderationModelVersion;
            return this;
        }

        public final void setModerationModelVersion(String moderationModelVersion) {
            this.moderationModelVersion = moderationModelVersion;
        }

        public final HumanLoopActivationOutput.Builder getHumanLoopActivationOutput() {
            return this.humanLoopActivationOutput != null ? this.humanLoopActivationOutput.toBuilder() : null;
        }

        @Override
        public final Builder humanLoopActivationOutput(HumanLoopActivationOutput humanLoopActivationOutput) {
            this.humanLoopActivationOutput = humanLoopActivationOutput;
            return this;
        }

        public final void setHumanLoopActivationOutput(HumanLoopActivationOutput.BuilderImpl humanLoopActivationOutput) {
            this.humanLoopActivationOutput = humanLoopActivationOutput != null ? humanLoopActivationOutput.build() : null;
        }

        @Override
        public DetectModerationLabelsResponse build() {
            return new DetectModerationLabelsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RekognitionResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DetectModerationLabelsResponse> {
        public Builder moderationLabels(Collection<ModerationLabel> var1);

        public Builder moderationLabels(ModerationLabel ... var1);

        public Builder moderationLabels(Consumer<ModerationLabel.Builder> ... var1);

        public Builder moderationModelVersion(String var1);

        public Builder humanLoopActivationOutput(HumanLoopActivationOutput var1);

        default public Builder humanLoopActivationOutput(Consumer<HumanLoopActivationOutput.Builder> humanLoopActivationOutput) {
            return this.humanLoopActivationOutput((HumanLoopActivationOutput)((HumanLoopActivationOutput.Builder)HumanLoopActivationOutput.builder().applyMutation(humanLoopActivationOutput)).build());
        }
    }
}

