/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.services.rekognition.model.Attribute;
import software.amazon.awssdk.services.rekognition.model.AttributesCopier;
import software.amazon.awssdk.services.rekognition.model.Image;
import software.amazon.awssdk.services.rekognition.model.RekognitionRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class IndexFacesRequest
extends RekognitionRequest
implements ToCopyableBuilder<Builder, IndexFacesRequest> {
    private final String collectionId;
    private final Image image;
    private final String externalImageId;
    private final List<String> detectionAttributes;

    private IndexFacesRequest(BuilderImpl builder) {
        super(builder);
        this.collectionId = builder.collectionId;
        this.image = builder.image;
        this.externalImageId = builder.externalImageId;
        this.detectionAttributes = builder.detectionAttributes;
    }

    public String collectionId() {
        return this.collectionId;
    }

    public Image image() {
        return this.image;
    }

    public String externalImageId() {
        return this.externalImageId;
    }

    public List<Attribute> detectionAttributes() {
        return TypeConverter.convert(this.detectionAttributes, Attribute::fromValue);
    }

    public List<String> detectionAttributesStrings() {
        return this.detectionAttributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.collectionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.image());
        hashCode = 31 * hashCode + Objects.hashCode(this.externalImageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.detectionAttributesStrings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IndexFacesRequest)) {
            return false;
        }
        IndexFacesRequest other = (IndexFacesRequest)((Object)obj);
        return Objects.equals(this.collectionId(), other.collectionId()) && Objects.equals(this.image(), other.image()) && Objects.equals(this.externalImageId(), other.externalImageId()) && Objects.equals(this.detectionAttributesStrings(), other.detectionAttributesStrings());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.collectionId() != null) {
            sb.append("CollectionId: ").append(this.collectionId()).append(",");
        }
        if (this.image() != null) {
            sb.append("Image: ").append(this.image()).append(",");
        }
        if (this.externalImageId() != null) {
            sb.append("ExternalImageId: ").append(this.externalImageId()).append(",");
        }
        if (this.detectionAttributesStrings() != null) {
            sb.append("DetectionAttributes: ").append(this.detectionAttributesStrings()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CollectionId": {
                return Optional.of(clazz.cast(this.collectionId()));
            }
            case "Image": {
                return Optional.of(clazz.cast(this.image()));
            }
            case "ExternalImageId": {
                return Optional.of(clazz.cast(this.externalImageId()));
            }
            case "DetectionAttributes": {
                return Optional.of(clazz.cast(this.detectionAttributesStrings()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends RekognitionRequest.BuilderImpl
    implements Builder {
        private String collectionId;
        private Image image;
        private String externalImageId;
        private List<String> detectionAttributes;

        private BuilderImpl() {
        }

        private BuilderImpl(IndexFacesRequest model) {
            this.collectionId(model.collectionId);
            this.image(model.image);
            this.externalImageId(model.externalImageId);
            this.detectionAttributes(model.detectionAttributes);
        }

        public final String getCollectionId() {
            return this.collectionId;
        }

        @Override
        public final Builder collectionId(String collectionId) {
            this.collectionId = collectionId;
            return this;
        }

        public final void setCollectionId(String collectionId) {
            this.collectionId = collectionId;
        }

        public final Image.Builder getImage() {
            return this.image != null ? this.image.toBuilder() : null;
        }

        @Override
        public final Builder image(Image image) {
            this.image = image;
            return this;
        }

        public final void setImage(Image.BuilderImpl image) {
            this.image = image != null ? image.build() : null;
        }

        public final String getExternalImageId() {
            return this.externalImageId;
        }

        @Override
        public final Builder externalImageId(String externalImageId) {
            this.externalImageId = externalImageId;
            return this;
        }

        public final void setExternalImageId(String externalImageId) {
            this.externalImageId = externalImageId;
        }

        public final Collection<String> getDetectionAttributes() {
            return this.detectionAttributes;
        }

        @Override
        public final Builder detectionAttributes(Collection<String> detectionAttributes) {
            this.detectionAttributes = AttributesCopier.copy(detectionAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder detectionAttributes(String ... detectionAttributes) {
            this.detectionAttributes(Arrays.asList(detectionAttributes));
            return this;
        }

        public final void setDetectionAttributes(Collection<String> detectionAttributes) {
            this.detectionAttributes = AttributesCopier.copy(detectionAttributes);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public IndexFacesRequest build() {
            return new IndexFacesRequest(this);
        }
    }

    public static interface Builder
    extends RekognitionRequest.Builder,
    CopyableBuilder<Builder, IndexFacesRequest> {
        public Builder collectionId(String var1);

        public Builder image(Image var1);

        default public Builder image(Consumer<Image.Builder> image) {
            return this.image((Image)((Image.Builder)Image.builder().apply(image)).build());
        }

        public Builder externalImageId(String var1);

        public Builder detectionAttributes(Collection<String> var1);

        public Builder detectionAttributes(String ... var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

